/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Person;
import com.imcode.entities.User;
import com.imcode.services.UserService;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/users"})
public class UserRestControllerImpl
extends AbstractRestController<User, Long, UserService> {
    @Autowired
    private UserService userService;

    @RequestMapping(method={RequestMethod.GET}, value={"/loggedin"})
    public Object getLoggedInUser(WebRequest webRequest) {
        User user = this.getCurrentUser(webRequest);
        LinkedHashMap<String, Object> loggedInUser = new LinkedHashMap<String, Object>();
        loggedInUser.put("id", user.getId());
        Person person = user.getPerson();
        loggedInUser.put("first_name", person.getFirstName());
        loggedInUser.put("last_name", person.getLastName());
        loggedInUser.put("rights", user.getRoleNames());
        return loggedInUser;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/current"})
    public User getCurrentUser(WebRequest webRequest) {
        User user = null;
        try {
            Authentication authentication = (Authentication)webRequest.getUserPrincipal();
            user = (User)authentication.getPrincipal();
            user = (User)this.userService.find((Object)user.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return user;
    }
}

