/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Activity;
import com.imcode.services.ActivityService;
import com.imcode.utils.IssueAttachmentFileUtil;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@RestController
@RequestMapping(value={"/v1/{format}/activities"})
public class ActivityRestControllerImpl
extends AbstractRestController<Activity, Long, ActivityService> {
    @Autowired
    private ActivityService activityService;

    @RequestMapping(value={"/attach/{activity_id}"}, method={RequestMethod.POST})
    public String setAttachment(@PathVariable(value="activity_id") Long activityId, @RequestParam(value="file") CommonsMultipartFile attachment, WebRequest webRequest) {
        Activity activity = (Activity)this.activityService.find((Object)activityId);
        activity.setFileName(attachment.getOriginalFilename());
        activity = (Activity)this.activityService.save((Object)activity);
        if (!attachment.isEmpty() && activity != null) {
            IssueAttachmentFileUtil issueAttachmentFileUtil = new IssueAttachmentFileUtil();
            issueAttachmentFileUtil.saveActivityAttachment(activity, (MultipartFile)attachment);
        }
        return activity.getFileName();
    }

    @RequestMapping(value={"/attach/{activity_id}"}, method={RequestMethod.GET})
    public void gatAttachment(@PathVariable(value="activity_id") Long activityId, HttpServletResponse response, WebRequest webRequest) {
        Activity activity = (Activity)this.activityService.find((Object)activityId);
        if (activity != null) {
            IssueAttachmentFileUtil issueAttachmentFileUtil = new IssueAttachmentFileUtil();
            issueAttachmentFileUtil.saveActivityAttachmentInResponse(activity, response);
        }
    }
}

