/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.form.upload;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;

public class FileOption
implements Serializable {
    private static final int DEFAULT_PREVIEW_ROW_COUNT = 10;
    private int previewRowsCount = 10;
    private Class<?> type;
    private String fileId;
    private String originalFileName;
    private int columnCount;
    private int skipRows = 0;
    private Collection<String[]> firstRows = new ArrayList<String[]>(this.previewRowsCount);
    private List<String> columnNameList = new ArrayList<String>();
    private boolean firstRowSkip = false;
    private Integer keyColumn;
    private List<?> result = new ArrayList();

    public static FileOption of(String fileId, MultipartFile file) {
        return FileOption.of(fileId, file, 10);
    }

    public static FileOption of(String fileId, MultipartFile file, int previewRowsCount) {
        FileOption instance = new FileOption();
        instance.previewRowsCount = previewRowsCount;
        instance.fileId = fileId;
        instance.originalFileName = file.getOriginalFilename();
        instance.fillPreviewLines(file);
        instance.columnNameList = Arrays.asList(new String[instance.columnCount]);
        return instance;
    }

    protected void fillPreviewLines(MultipartFile file) {
        try {
            String[] row;
            InputStreamResource resource = new InputStreamResource((InputStream)new ByteArrayInputStream(file.getBytes()));
            DefaultLineMapper lineMapper = new DefaultLineMapper();
            lineMapper.setLineTokenizer((LineTokenizer)new DelimitedLineTokenizer());
            lineMapper.setFieldSetMapper(FieldSet::getValues);
            FlatFileItemReader itemReader = new FlatFileItemReader();
            itemReader.setResource((Resource)resource);
            itemReader.setLineMapper((LineMapper)lineMapper);
            itemReader.open(new ExecutionContext());
            for (int i = 0; i < 10 && (row = (String[])itemReader.read()) != null; ++i) {
                this.firstRows.add(row);
                this.columnCount = Math.max(this.columnCount, row.length);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getSkipRows() {
        return this.skipRows;
    }

    public void setSkipRows(int skipRows) {
        this.skipRows = skipRows;
    }

    public Collection<String[]> getFirstRows() {
        return this.firstRows;
    }

    public void setFirstRows(Collection<String[]> firstRows) {
        this.firstRows = firstRows;
    }

    public List<String> getColumnNameList() {
        return this.columnNameList;
    }

    public void setColumnNameList(List<String> columnNameList) {
        this.columnNameList = columnNameList;
    }

    public boolean isFirstRowSkip() {
        return this.firstRowSkip;
    }

    public void setFirstRowSkip(boolean firstRowSkip) {
        this.firstRowSkip = firstRowSkip;
    }

    public Integer getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(Integer keyColumn) {
        this.keyColumn = keyColumn;
    }

    public List<?> getResult() {
        return this.result;
    }

    public void setResult(List<?> result) {
        this.result = result;
    }
}

