/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.restful;

import com.imcode.controllers.AbstractRestController;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.entities.User;
import com.imcode.services.GuardianService;
import com.imcode.services.PersonService;
import com.imcode.services.PupilService;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/v1/{format}/pupils"})
public class PupilRestControllerImpl
extends AbstractRestController<Pupil, Long, PupilService> {
    @Autowired
    private GuardianService guardianService;
    @Autowired
    private PersonService personService;

    @Override
    public Object getAll(WebRequest webRequest, Model model) {
        Guardian guardian;
        Person person;
        Collection pupilList = new ArrayList();
        User user = this.getUser(webRequest);
        if (user == null) {
            throw new RuntimeException("User unauthorized!");
        }
        if (user.hasRoles(new String[]{"ROLE_GUARDIAN"}) && (person = user.getPerson()) != null && (guardian = (Guardian)this.guardianService.findFirstByPersonalId(person.getPersonalId())) != null) {
            pupilList = guardian.getPupils();
        }
        return pupilList;
    }

    private Person getPerson(WebRequest webRequest) {
        Person person = null;
        User user = this.getUser(webRequest);
        if (user != null) {
            person = user.getPerson();
        }
        return person;
    }

    private User getUser(WebRequest webRequest) {
        User user = null;
        try {
            Authentication authentication = (Authentication)webRequest.getUserPrincipal();
            user = (User)authentication.getPrincipal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return user;
    }
}

