/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.form.upload.loaders;

import com.imcode.controllers.html.form.upload.FileOption;
import com.imcode.controllers.html.form.upload.loaders.ByIdFinder;
import com.imcode.services.AbstractService;
import com.imcode.services.GenericService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.validation.BindException;
import org.springframework.validation.DataBinder;

public class EntityLoader<T> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Class<T> entityType;
    private ConversionService conversionService;
    private Set<String> allowedFieldSet;
    private GenericService<T, ?> entityServise;
    private Map<String, Function<String, T>> finders = new LinkedHashMap<String, Function<String, T>>();
    private Supplier<T> newEntitySupplier;

    public EntityLoader(Class<T> entityType, ConversionService conversionService) {
        this.entityType = entityType;
        this.conversionService = conversionService;
        this.newEntitySupplier = () -> {
            try {
                return entityType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        this.finders.put("id", new ByIdFinder<T, Long>(this.entityServise, Long.class, conversionService));
    }

    public EntityLoader(Class<T> entityType) {
        this(entityType, (ConversionService)new DefaultConversionService());
    }

    public GenericService<T, ?> getEntityServise() {
        return this.entityServise;
    }

    public Map<String, Function<String, T>> getFinders() {
        return this.finders;
    }

    public void setFinders(Map<String, Function<String, T>> finders) {
        this.finders = finders;
    }

    public void setEntityServise(GenericService<T, ?> entityServise) {
        this.entityServise = entityServise;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Set<String> getAllowedFieldSet() {
        return this.allowedFieldSet;
    }

    public void setAllowedFieldSet(Set<String> allowedFieldSet) {
        this.allowedFieldSet = allowedFieldSet;
    }

    public void bindData(T target, Map<?, ?> data) {
        DataBinder binder = new DataBinder(target);
        binder.setConversionService(this.conversionService);
        binder.bind((PropertyValues)new MutablePropertyValues(data));
    }

    public FieldSetMapper<T> getFieldSetMapper(FileOption fileOption) {
        return new FieldSetMapperImpl(fileOption);
    }

    public ItemWriter<T> getItemWriter() {
        return new ItemWriterImpl();
    }

    private Function<String, T> getEntityFinder(String finderName) {
        Function<String, T> finder = this.finders.get(finderName);
        return finder;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public Supplier<T> getNewEntitySupplier() {
        return this.newEntitySupplier;
    }

    public void setNewEntitySupplier(Supplier<T> newEntitySupplier) {
        this.newEntitySupplier = newEntitySupplier;
    }

    private class ItemWriterImpl
    implements ItemWriter<T> {
        private ItemWriterImpl() {
        }

        public void write(List<? extends T> items) throws Exception {
            List entityList = items;
            AbstractService service = (AbstractService)EntityLoader.this.entityServise;
            for (int i = 0; i < entityList.size(); ++i) {
                Object entity = entityList.get(i);
                try {
                    entityList.set(i, service.saveWithoutFlush(entity));
                    continue;
                }
                catch (Exception e) {
                    EntityLoader.this.logger.warning(e::getMessage);
                }
            }
            service.flush();
        }
    }

    private class FieldSetMapperImpl
    implements FieldSetMapper<T> {
        private final FileOption fileOption;

        FieldSetMapperImpl(FileOption fileOption) {
            this.fileOption = fileOption;
        }

        public T mapFieldSet(FieldSet fieldSet) throws BindException {
            Object entity = null;
            Integer indexColumn = this.fileOption.getKeyColumn();
            String indexColumnName = fieldSet.getNames()[indexColumn];
            Function finder = EntityLoader.this.getEntityFinder(indexColumnName);
            if (finder == null) {
                throw new BindException((Object)EntityLoader.this.entityType, "finder '" + indexColumnName + "' not found.");
            }
            String indexColumnValue = fieldSet.readString(indexColumn.intValue());
            entity = finder.apply(indexColumnValue);
            if (entity == null) {
                entity = EntityLoader.this.newEntitySupplier.get();
            }
            EntityLoader.this.bindData(entity, fieldSet.getProperties());
            return entity;
        }
    }
}

