/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services;

import com.imcode.entities.Application;
import com.imcode.entities.LogEvent;
import com.imcode.entities.User;
import com.imcode.entities.observer.LogEventObserver;
import com.imcode.entities.observer.ObserverRegistry;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.services.LogEventService;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class EntityLoggerObserver
implements LogEventObserver<AbstractIdEntity<Long>> {
    @Autowired
    private LogEventService eventService;

    @PostConstruct
    public void postConstruct() {
        ObserverRegistry.register((LogEventObserver)this);
    }

    public boolean handles(Class<?> clazz) {
        return Application.class.isAssignableFrom(clazz);
    }

    public void notifyChange(AbstractIdEntity<Long> model, LogEvent.Action action, String field, Object previousValue, Object newValue) {
        User user = EntityLoggerObserver.getCurrentUser();
        LogEvent event = new LogEvent(model, action, field, EntityLoggerObserver.getAsString(previousValue), EntityLoggerObserver.getAsString(newValue), user);
        this.eventService.saveAsync(event);
    }

    public static User getCurrentUser() {
        User user = null;
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof User) {
            user = (User)principal;
        }
        return user;
    }

    public static String getAsString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (Iterable.class.isAssignableFrom(obj.getClass())) {
            return EntityLoggerObserver.toStringIterable((Iterable)obj);
        }
        return obj.toString();
    }

    private static String compactToString(AbstractIdEntity<?> model) {
        return model.getClass().getSimpleName() + "[" + model.getId() + "]";
    }

    private static String toStringIterable(Iterable iterable) {
        StringBuilder builder = new StringBuilder("Iterable(");
        boolean hasElements = false;
        for (Object element : iterable) {
            hasElements = true;
            if (AbstractIdEntity.class.isAssignableFrom(element.getClass())) {
                builder.append(EntityLoggerObserver.compactToString((AbstractIdEntity)element));
            } else {
                builder.append(element.toString());
            }
            builder.append(", ");
        }
        if (hasElements) {
            builder.delete(builder.length() - 3, builder.length() - 1);
        }
        builder.append(")");
        return builder.toString();
    }
}

