/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.tiles.preparers;

import com.imcode.entities.interfaces.JpaEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.ViewPreparerSupport;
import org.springframework.stereotype.Component;

@Component
public class EntityListPreparer
extends ViewPreparerSupport {
    private static final String DEFAULT_COLUMN_NAMES = "id,name";

    public void execute(TilesRequestContext tilesContext, AttributeContext attributeContext) {
        Map requestAttributes = tilesContext.getRequestScope();
        String entityListTitle = (String)requestAttributes.get("entityListTitle");
        List entities = (List)requestAttributes.get("entities");
        HashMap aditionalAttributes = new HashMap();
        String entityClassName = (String)requestAttributes.get("entityClassName");
        String columnNames = (String)requestAttributes.get("columnNames");
        if (entityListTitle == null && entities != null) {
            Iterator iterator = entities.iterator();
            if (entityClassName != null) {
                entityListTitle = entityClassName;
            } else if (iterator.hasNext()) {
                JpaEntity entity = (JpaEntity)iterator.next();
                entityListTitle = entity.getClassDescription();
            } else {
                entityListTitle = "Entity";
            }
            entityListTitle = entityListTitle + " list";
            attributeContext.putAttribute("entityListTitle", new Attribute((Object)entityListTitle), true);
        }
        if (columnNames == null || !(columnNames instanceof String) || columnNames.isEmpty()) {
            attributeContext.putAttribute("columnNames", new Attribute((Object)DEFAULT_COLUMN_NAMES), true);
        }
    }
}

