/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.springframework.context.support.GenericXmlApplicationContext;

public class StaticUtils {
    public static void saveObjectToFile(Object obj, String fileName) {
        try (ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(fileName));){
            stream.writeObject(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadObjectFromFile(String fileName) {
        try (ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(fileName));){
            Object object = inputStream.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GenericXmlApplicationContext getApplicationContext() {
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext();
        ctx.load(new String[]{"classpath:/spring/data.xml"});
        ctx.refresh();
        return ctx;
    }
}

