/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2;

import com.imcode.saml2.store.SAMLRequestStore;
import com.imcode.saml2.utils.SAMLUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLRequestSender {
    private static Logger log = LoggerFactory.getLogger(SAMLRequestSender.class);
    private SAMLAuthnRequestBuilder samlAuthnRequestBuilder = new SAMLAuthnRequestBuilder();
    private MessageEncoder messageEncoder = new MessageEncoder();

    public void sendSAMLAuthRequest(HttpServletRequest request, HttpServletResponse servletResponse, String spId, String acsUrl, String idpSSOUrl) throws Exception {
        String idpUrl = idpSSOUrl;
        AuthnRequest authnRequest = this.samlAuthnRequestBuilder.buildRequest(spId, acsUrl, idpUrl);
        String key = SAMLRequestStore.getInstance().storeRequest();
        authnRequest.setID(key);
        log.debug("SAML Authentication message : {} ", (Object)SAMLUtils.SAMLObjectToString((XMLObject)authnRequest));
        String redirectURL = this.messageEncoder.encode((SAMLObject)authnRequest, idpUrl, request.getRequestURI());
        HttpServletResponseAdapter responseAdapter = new HttpServletResponseAdapter(servletResponse, request.isSecure());
        HTTPTransportUtils.addNoCacheHeaders((HTTPOutTransport)responseAdapter);
        HTTPTransportUtils.setUTF8Encoding((HTTPOutTransport)responseAdapter);
        responseAdapter.sendRedirect(redirectURL);
    }

    private static class MessageEncoder
    extends HTTPRedirectDeflateEncoder {
        private MessageEncoder() {
        }

        public String encode(SAMLObject message, String endpointURL, String relayState) throws MessageEncodingException {
            String encodedMessage = this.deflateAndBase64Encode(message);
            return this.buildRedirectURL(endpointURL, relayState, encodedMessage);
        }

        public String buildRedirectURL(String endpointURL, String relayState, String message) {
            URLBuilder urlBuilder = new URLBuilder(endpointURL);
            List queryParams = urlBuilder.getQueryParams();
            queryParams.clear();
            queryParams.add(new Pair((Object)"mgvhostparam", (Object)"0"));
            queryParams.add(new Pair((Object)"SAMLRequest", (Object)message));
            if (this.checkRelayState(relayState)) {
                queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
            }
            return urlBuilder.buildURL();
        }
    }

    private static class SAMLAuthnRequestBuilder {
        private SAMLAuthnRequestBuilder() {
        }

        public AuthnRequest buildRequest(String spProviderId, String acsUrl, String idpUrl) {
            IssuerBuilder issuerBuilder = new IssuerBuilder();
            Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml2p");
            issuer.setValue(spProviderId);
            DateTime issueInstant = new DateTime();
            AuthnRequestBuilder authRequestBuilder = new AuthnRequestBuilder();
            AuthnRequest authRequest = authRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "saml2p");
            authRequest.setForceAuthn(Boolean.valueOf(false));
            authRequest.setIssueInstant(issueInstant);
            authRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            authRequest.setAssertionConsumerServiceURL(acsUrl);
            authRequest.setIssuer(issuer);
            authRequest.setVersion(SAMLVersion.VERSION_20);
            authRequest.setDestination(idpUrl);
            return authRequest;
        }
    }
}

