/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2.store;

import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.repositories.RoleRepository;
import com.imcode.repositories.UserRepository;
import com.imcode.saml2.store.SAMLSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SAMLSessionManager {
    private static String SAML_SESSION_INFO = "SAML_SESSION_INFO";
    private static SAMLSessionManager instance = new SAMLSessionManager();
    private static final String SESSION_ATTRIBUTE__NEXT_URL = "next_url";

    private SAMLSessionManager() {
    }

    public static SAMLSessionManager getInstance() {
        return instance;
    }

    public void createSAMLSession(HttpServletRequest request, HttpServletResponse response, SAMLMessageContext<Response, SAMLObject, NameID> samlMessageContext) {
        List assertions = ((Response)samlMessageContext.getInboundSAMLMessage()).getAssertions();
        NameID nameId = assertions.size() != 0 && ((Assertion)assertions.get(0)).getSubject() != null ? ((Assertion)assertions.get(0)).getSubject().getNameID() : null;
        String nameValue = nameId == null ? null : nameId.getValue();
        SAMLSessionInfo samlSessionInfo = new SAMLSessionInfo(nameValue, this.getAttributesMap(this.getSAMLAttributes(assertions)), this.getSAMLSessionValidTo(assertions));
        request.getSession().setAttribute(SAML_SESSION_INFO, (Object)samlSessionInfo);
        this.loginUser(samlSessionInfo, request, response);
    }

    public void loginUser(SAMLSessionInfo samlSessionInfo, HttpServletRequest request, HttpServletResponse response) {
        Map<String, String> attributes;
        String samlUserId;
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext());
        UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
        User user = userRepository.findBySaml2Id(samlUserId = (attributes = samlSessionInfo.getAttributes()).get("Subject_SerialNumber"));
        if (user == null) {
            RoleRepository roleRepository = (RoleRepository)context.getBean(RoleRepository.class);
            Role roleUser = (Role)roleRepository.findFirstByName("ROLE_USER");
            user = new User(samlUserId, UUID.randomUUID().toString(), Boolean.valueOf(true), Collections.singleton(roleUser));
            user.setSaml2Id(samlUserId);
            user = (User)userRepository.save(user);
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, (Collection)user.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        try {
            successHandler.onAuthenticationSuccess(request, response, (Authentication)authentication);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private User prepareUser(SAMLSessionInfo sessionInfo) {
        return null;
    }

    public boolean isSAMLSessionValid(HttpSession session) {
        SAMLSessionInfo samlSessionInfo = (SAMLSessionInfo)session.getAttribute(SAML_SESSION_INFO);
        return samlSessionInfo != null && (samlSessionInfo.getValidTo() == null || new Date().before(samlSessionInfo.getValidTo()));
    }

    public SAMLSessionInfo getSAMLSession(HttpSession session) {
        return (SAMLSessionInfo)session.getAttribute(SAML_SESSION_INFO);
    }

    public void destroySAMLSession(HttpSession session) {
        session.removeAttribute(SAML_SESSION_INFO);
    }

    public List<Attribute> getSAMLAttributes(List<Assertion> assertions) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (assertions != null) {
            for (Assertion assertion : assertions) {
                for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                    for (Attribute attribute : attributeStatement.getAttributes()) {
                        attributes.add(attribute);
                    }
                }
            }
        }
        return attributes;
    }

    public Date getSAMLSessionValidTo(List<Assertion> assertions) {
        DateTime sessionNotOnOrAfter = null;
        if (assertions != null) {
            for (Assertion assertion : assertions) {
                for (AuthnStatement statement : assertion.getAuthnStatements()) {
                    sessionNotOnOrAfter = statement.getSessionNotOnOrAfter();
                }
            }
        }
        return sessionNotOnOrAfter != null ? sessionNotOnOrAfter.toCalendar(Locale.getDefault()).getTime() : null;
    }

    public Map<String, String> getAttributesMap(List<Attribute> attributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Attribute attribute : attributes) {
            result.put(attribute.getName(), attribute.getDOM().getTextContent());
        }
        return result;
    }
}

