/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.oauth2;

import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Qualifier(value="accessConfirmationController")
@SessionAttributes(value={"authorizationRequest"})
public class AccessConfirmationController {
    @Autowired
    private ClientDetailsService clientDetailsService;
    @Autowired
    private ApprovalStore approvalStore;

    @RequestMapping(value={"/oauth/confirm_access"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model, Principal principal, @RequestParam(value="display", required=false) String display) throws Exception {
        AuthorizationRequest clientAuth = (AuthorizationRequest)model.remove("authorizationRequest");
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
        model.put("auth_request", clientAuth);
        model.put("client", client);
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        for (String scope : clientAuth.getScope()) {
            scopes.put("scope." + scope, "false");
        }
        for (Approval approval : this.approvalStore.getApprovals(principal.getName(), client.getClientId())) {
            if (!clientAuth.getScope().contains(approval.getScope())) continue;
            scopes.put("scope." + approval.getScope(), approval.getStatus() == Approval.ApprovalStatus.APPROVED ? "true" : "false");
        }
        model.put("scopes", scopes);
        String confurmationView = "access_confirmation";
        if (display != null && "popup".equalsIgnoreCase(display)) {
            confurmationView = "access_confirmation_popup";
        }
        return new ModelAndView(confurmationView, model);
    }

    @RequestMapping(value={"/oauth/error"})
    public String handleError(Map<String, Object> model) throws Exception {
        model.put("message", "There was a problem with the OAuth2 protocol");
        return "oauth_error";
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setApprovalStore(ApprovalStore approvalStore) {
        this.approvalStore = approvalStore;
    }
}

