/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.converters;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.util.StringUtils;

public class NotNullStringToCollectionConverter
implements ConditionalGenericConverter {
    private final ConfigurableConversionService conversionService;

    public NotNullStringToCollectionConverter(ConversionService conversionService) {
        this.conversionService = (ConfigurableConversionService)conversionService;
        this.conversionService.addConverter((GenericConverter)this);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Collection.class));
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.getElementTypeDescriptor() == null || this.conversionService.canConvert(sourceType, targetType.getElementTypeDescriptor());
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String string = (String)source;
        String[] fields = StringUtils.commaDelimitedListToStringArray((String)string);
        TypeDescriptor elementDesc = targetType.getElementTypeDescriptor();
        Collection target = CollectionFactory.createCollection((Class)targetType.getType(), (Class)(elementDesc != null ? elementDesc.getType() : null), (int)fields.length);
        if (elementDesc == null) {
            for (String field : fields) {
                target.add(field.trim());
            }
        } else {
            for (String field : fields) {
                Object targetElement = this.conversionService.convert((Object)field.trim(), sourceType, elementDesc);
                if (targetElement == null) continue;
                target.add(targetElement);
            }
        }
        return target;
    }
}

