/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services.csv;

import com.imcode.controllers.html.form.upload.FileOption;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.entities.superclasses.ContactInformation;
import com.imcode.services.GenericService;
import com.imcode.services.GuardianService;
import com.imcode.services.csv.CsvFieldSetMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;

@Component
@Scope(value="request")
public class GuardianFieldSetMapper
extends CsvFieldSetMapper<Guardian> {
    @Autowired
    private GuardianService service;
    private Supplier<Guardian> entitySupplier = () -> {
        Guardian guardian = new Guardian();
        guardian.setPerson(new Person());
        return guardian;
    };
    private Map<String, BiConsumer<? super Guardian, String>> setters = new HashMap<String, BiConsumer<? super Guardian, String>>();
    private Map<String, Function<String, ? super Guardian>> finders = new HashMap<String, Function<String, ? super Guardian>>();
    private FileOption fileOption;

    public GuardianFieldSetMapper() {
        this.init();
    }

    public FileOption getFileOption() {
        return this.fileOption;
    }

    @Override
    public void setFileOption(FileOption fileOption) {
        this.fileOption = fileOption;
    }

    @Override
    public void setService(GenericService<Guardian, ?> service) {
        this.service = (GuardianService)service;
    }

    public Guardian mapFieldSet(FieldSet fieldSet) throws BindException {
        String finderName = this.fileOption.getColumnNameList().get(this.fileOption.getKeyColumn());
        Function<String, ? super Guardian> finder = this.finders.get(finderName);
        String keyValue = fieldSet.readString(finderName);
        Guardian guardian = finder.apply(keyValue);
        for (String columnName : fieldSet.getNames()) {
            BiConsumer<? super Guardian, String> setter = this.setters.get(columnName);
            if (setter == null) continue;
            setter.accept((Guardian)guardian, fieldSet.readString(columnName));
        }
        return guardian;
    }

    private void init() {
        Function<String, Guardian> idFinder = id -> Optional.ofNullable(this.service.find((Object)Long.valueOf(id))).orElseGet(this.entitySupplier);
        Function<String, Guardian> personalIdFinder = personalId -> Optional.ofNullable(this.service.findFirstByPersonalId(personalId)).orElseGet(this.entitySupplier);
        this.finders.put("id", idFinder);
        this.finders.put("personalId", personalIdFinder);
        AddressValueSetter emailSetter = new AddressValueSetter(jpaPersonalizedEntity -> {
            Person person = jpaPersonalizedEntity.getPerson();
            Email addressValue = person.getEmail(CommunicationTypeEnum.HOME);
            if (addressValue == null) {
                addressValue = Email.of((CommunicationTypeEnum)CommunicationTypeEnum.HOME);
                person.setEmail(addressValue);
            }
            return addressValue;
        });
        AddressValueSetter phoneSetter = new AddressValueSetter(jpaPersonalizedEntity -> {
            Person person = jpaPersonalizedEntity.getPerson();
            Phone addressValue = person.getPhone(CommunicationTypeEnum.HOME);
            if (addressValue == null) {
                addressValue = Phone.of((CommunicationTypeEnum)CommunicationTypeEnum.HOME);
                person.setPhone(addressValue);
            }
            return addressValue;
        });
        BiConsumer<Guardian, String> personalId2 = (g, pid) -> g.getPerson().setPersonalId(pid);
        BiConsumer<Guardian, String> firstName = (g, fn) -> g.getPerson().setFirstName(fn);
        BiConsumer<Guardian, String> lastName = (g, ln) -> g.getPerson().setFirstName(ln);
        AddressValueSetter email = emailSetter;
        AddressValueSetter phone = phoneSetter;
        this.setters.put("personalId", personalId2);
        this.setters.put("firstName", firstName);
        this.setters.put("lastName", lastName);
        this.setters.put("email", email);
        this.setters.put("phone", phone);
    }

    public GuardianService getService() {
        return this.service;
    }

    public void setService(GuardianService service) {
        this.service = service;
    }

    public Supplier<Guardian> getEntitySupplier() {
        return this.entitySupplier;
    }

    public void setEntitySupplier(Supplier<Guardian> entitySupplier) {
        this.entitySupplier = entitySupplier;
    }

    public Map<String, BiConsumer<? super Guardian, String>> getSetters() {
        return this.setters;
    }

    public void setSetters(Map<String, BiConsumer<? super Guardian, String>> setters) {
        this.setters = setters;
    }

    public Map<String, Function<String, ? super Guardian>> getFinders() {
        return this.finders;
    }

    public void setFinders(Map<String, Function<String, ? super Guardian>> finders) {
        this.finders = finders;
    }

    public Set<String> getFieldNames() {
        return this.setters.keySet();
    }

    public Set<String> getIndexFieldNames() {
        return this.finders.keySet();
    }

    private static class AddressValueSetter
    implements BiConsumer<JpaPersonalizedEntity, String> {
        private final Function<JpaPersonalizedEntity, ? extends ContactInformation<?>> addressGetter;

        AddressValueSetter(Function<JpaPersonalizedEntity, ? extends ContactInformation<?>> addressGetter) {
            this.addressGetter = addressGetter;
        }

        @Override
        public void accept(JpaPersonalizedEntity personalizedEntity, String value) {
            ContactInformation<?> addressValue = this.addressGetter.apply(personalizedEntity);
            addressValue.setValue(value);
        }
    }
}

