/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.Person;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.services.GenericService;
import com.imcode.services.PersonService;
import java.util.List;
import org.springframework.batch.item.ItemWriter;

class PersonalizedItemWriter<T extends JpaPersonalizedEntity>
implements ItemWriter<T> {
    private final GenericService<T, ?> entityService;
    private final PersonService personService;

    PersonalizedItemWriter(GenericService<T, ?> entityService, PersonService personService) {
        this.entityService = entityService;
        this.personService = personService;
    }

    public void write(List<? extends T> items) throws Exception {
        for (JpaPersonalizedEntity item : items) {
            Person person = item.getPerson();
            person = (Person)this.personService.save((Object)person);
            item.setPerson(person);
            this.entityService.save((Object)item);
        }
    }
}

