/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.imcode.controllers.html.PersonalizedItemWriter;
import com.imcode.controllers.html.form.upload.FileOption;
import com.imcode.controllers.html.form.upload.FileUploadForm;
import com.imcode.controllers.html.form.upload.FileUploadOptionsForm;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.misc.UploadFileManager;
import com.imcode.services.GenericService;
import com.imcode.services.GuardianService;
import com.imcode.services.PersonService;
import com.imcode.services.csv.CsvFieldSetMapper;
import com.imcode.services.csv.GuardianFieldSetMapper;
import com.sun.net.httpserver.HttpPrincipal;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/csv"})
public class CsvLoaderController {
    private static final String UPLOAD_FILE_MANAGER = "uploadFileManager";
    @Autowired
    private ApplicationContext applicationContext;
    private Map<Class<?>, Supplier<FieldSetMapper>> fieldSetMappers;

    @RequestMapping(method={RequestMethod.GET})
    public String step1() {
        return "csv/file_upload_step1";
    }

    @RequestMapping(value={"/step2"}, method={RequestMethod.POST})
    public String step2(@ModelAttribute(value="uploadForm") FileUploadForm uploadForm, Model map, HttpServletRequest request) {
        List<MultipartFile> files = uploadForm.getFiles();
        LinkedHashMap<Class<Guardian>, Set<String>> typeMap = new LinkedHashMap<Class<Guardian>, Set<String>>();
        typeMap.put(Guardian.class, new GuardianFieldSetMapper().getFieldNames());
        Set mockEntityProperties = (Set)typeMap.get(Person.class);
        ArrayList<FileOption> fileOptionList = new ArrayList<FileOption>();
        FileUploadOptionsForm fileUploadOptionsForm = new FileUploadOptionsForm();
        fileUploadOptionsForm.setFileOptionList(fileOptionList);
        HttpPrincipal principal = new HttpPrincipal("Admin", "pass");
        if (null != files && files.size() > 0) {
            UploadFileManager fileManager = new UploadFileManager(principal);
            HttpSession session = request.getSession(true);
            session.setAttribute(UPLOAD_FILE_MANAGER, (Object)fileManager);
            for (MultipartFile multipartFile : files) {
                String fileId = fileManager.put(multipartFile);
                fileOptionList.add(FileOption.of(fileId, multipartFile, 10));
            }
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String typeMapJson = null;
        try {
            typeMapJson = objectMapper.writeValueAsString(typeMap);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        map.addAttribute("fileUploadOptionsForm", (Object)fileUploadOptionsForm);
        map.addAttribute("typeMap", typeMap);
        map.addAttribute("typeMapJson", (Object)typeMapJson);
        map.addAttribute("mockEntityProperties", (Object)mockEntityProperties);
        return "csv/file_upload_step2";
    }

    @RequestMapping(value={"/step3"}, method={RequestMethod.POST})
    public String step3(@ModelAttribute(value="fileUploadOptionsForm") FileUploadOptionsForm optionsForm, Model map, HttpSession session) {
        List<Object> result = new ArrayList();
        System.out.println("hello");
        UploadFileManager uploadFileManager = (UploadFileManager)session.getAttribute(UPLOAD_FILE_MANAGER);
        for (FileOption fileOption : optionsForm.getFileOptionList()) {
            Path file = uploadFileManager.getFile(fileOption.getFileId());
            result = this.parseFile(fileOption, file);
        }
        return "csv/file_upload_step3";
    }

    private List<Guardian> parseFile(FileOption fileOption, Path file) {
        ArrayList<Guardian> result = new ArrayList<Guardian>();
        if (file == null || Files.notExists(file, new LinkOption[0])) {
            throw new RuntimeException("file not found");
        }
        FileSystemResource resource = new FileSystemResource(file.toFile());
        FlatFileItemReader itemReader = new FlatFileItemReader();
        itemReader.setResource((Resource)resource);
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer();
        tokenizer.setNames(fileOption.getColumnNameList().toArray(new String[fileOption.getColumnNameList().size()]));
        lineMapper.setLineTokenizer((LineTokenizer)tokenizer);
        FieldSetMapper<Guardian> fieldMapper = this.getMapper(Guardian.class, fileOption);
        lineMapper.setFieldSetMapper(fieldMapper);
        itemReader.setLineMapper((LineMapper)lineMapper);
        itemReader.setLinesToSkip(fileOption.getSkipRows());
        itemReader.open(new ExecutionContext());
        Guardian g = null;
        try {
            while ((g = (Guardian)itemReader.read()) != null) {
                result.add(g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PersonalizedItemWriter<Guardian> itemWriter = new PersonalizedItemWriter<Guardian>((GenericService)this.applicationContext.getBean(GuardianService.class), (PersonService)this.applicationContext.getBean(PersonService.class));
        try {
            itemWriter.write(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Set<String> getBeanFields(Class<?> clazz) {
        TreeSet<String> result = new TreeSet<String>();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            Set fieldSet = Arrays.stream(fields).map(Field::getName).collect(Collectors.toSet());
            result.addAll(fieldSet);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Set<String> getBeanFieldsRecursively(Class<?> clazz, String prefix) {
        TreeSet<String> result = new TreeSet<String>();
        String string = prefix = prefix.length() == 0 ? prefix : prefix + ".";
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String fieldName = prefix + field.getName();
                Class<?> fieldType = field.getType();
                result.add(fieldName);
                if (ClassUtils.isPrimitiveOrWrapper(fieldType)) continue;
                result.addAll(CsvLoaderController.getBeanFieldsRecursively(fieldType, fieldName));
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Set<String> getBeanFieldsRecursively(Class<?> clazz) {
        return CsvLoaderController.getBeanFieldsRecursively(clazz, "");
    }

    public <T> FieldSetMapper<T> getMapper(Class<T> clazz, FileOption fileOption) {
        GuardianFieldSetMapper fieldSetMapper = new GuardianFieldSetMapper();
        ((CsvFieldSetMapper)fieldSetMapper).setFileOption(fileOption);
        GuardianService guardianService = (GuardianService)this.applicationContext.getBean(GuardianService.class);
        ((CsvFieldSetMapper)fieldSetMapper).setService(guardianService);
        return fieldSetMapper;
    }

    @PostConstruct
    public void init() {
    }

    public static void main(String[] args) {
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Map<Class<?>, Supplier<FieldSetMapper>> getFieldSetMappers() {
        return this.fieldSetMappers;
    }

    public void setFieldSetMappers(Map<Class<?>, Supplier<FieldSetMapper>> fieldSetMappers) {
        this.fieldSetMappers = fieldSetMappers;
    }
}

