/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;

public class PathExtensionContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private static final boolean JAF_PRESENT = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)PathExtensionContentNegotiationStrategy.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(PathExtensionContentNegotiationStrategy.class);
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private boolean useJaf = JAF_PRESENT;

    public PathExtensionContentNegotiationStrategy(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    public PathExtensionContentNegotiationStrategy() {
        super(null);
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    protected String getMediaTypeKey(NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (servletRequest == null) {
            logger.warn((Object)"An HttpServletRequest is required to determine the media type key");
            return null;
        }
        String path = urlPathHelper.getLookupPathForRequest(servletRequest);
        List fileTypes = this.getAllFileExtensions();
        for (String fileType : fileTypes) {
            String formatVariable = "/" + fileType + "/";
            if (path.indexOf(formatVariable) == -1) continue;
            return fileType;
        }
        return null;
    }

    protected void handleMatch(String extension, MediaType mediaType) {
    }

    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension) {
        MediaType jafMediaType;
        if (this.useJaf && (jafMediaType = JafMediaTypeFactory.getMediaType("file." + extension)) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)jafMediaType)) {
            return jafMediaType;
        }
        return null;
    }

    static {
        urlPathHelper.setUrlDecode(false);
    }

    private static class JafMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = JafMediaTypeFactory.initFileTypeMap();

        private JafMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap initFileTypeMap() {
            ClassPathResource resource = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (resource.exists()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading Java Activation Framework FileTypeMap from " + resource));
                }
                InputStream inputStream = null;
                try {
                    inputStream = resource.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Loading default Java Activation Framework FileTypeMap");
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

