/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.misc.errors;

import com.imcode.misc.errors.Error;
import java.util.Locale;
import org.springframework.context.MessageSource;

public class ErrorFactory {
    private MessageSource messageSource;

    public Error getErrorWithDescription(int id, Locale locale) {
        if (locale == null) {
            locale = new Locale("en");
        }
        String key = String.valueOf(id);
        String description = this.messageSource.getMessage(key, null, "Unknown error", locale);
        Error error = new Error(key, description);
        return error;
    }

    public Error getErrorWithDescription(int id) {
        return this.getErrorWithDescription(id, null);
    }

    public Error getError(String id) {
        return new Error(id);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

