/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.misc;

import com.imcode.entities.AcademicYear;
import com.imcode.entities.Application;
import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.entities.Role;
import com.imcode.entities.School;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.User;
import com.imcode.entities.enums.AuthorizedGrantType;
import com.imcode.entities.enums.ServiceTypeEnum;
import com.imcode.entities.enums.StatementStatus;
import com.imcode.entities.oauth2.ClientRole;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.repositories.AcademicYearRepository;
import com.imcode.repositories.ApplicationRepository;
import com.imcode.repositories.PersonRepository;
import com.imcode.repositories.PupilRepository;
import com.imcode.repositories.RoleRepository;
import com.imcode.repositories.SchoolClassRepository;
import com.imcode.repositories.SchoolRepository;
import com.imcode.repositories.UserRepository;
import com.imcode.repositories.oauth2.ClientRoleRepository;
import com.imcode.repositories.oauth2.ClietnDetailsRepository;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.test.jdbc.JdbcTestUtils;

@Service
public class Initializator {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Autowired
    private ClietnDetailsRepository clietnDetailsRepository;
    @Autowired
    private ClientRoleRepository clientRoleRepository;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    private PupilRepository pupilRepository;
    @Autowired
    private SchoolClassRepository schoolClassRepository;
    @Autowired
    private SchoolRepository schoolRepository;
    @Autowired
    private AcademicYearRepository academicYearRepository;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void init() {
        this.intializeSecurityJpa();
        this.intializeOAuth2Jpa();
        this.initializeToken();
        this.initializeStatementJpa();
        this.initializePupilJpa();
    }

    private void initializePupilJpa() {
        List PupilList = this.pupilRepository.findAll();
        if (PupilList.size() == 0) {
            Person person = new Person();
            person.setId((Serializable)Long.valueOf(1L));
            person.setFirstName("Vitaliy");
            person.setLastName("Sereda");
            person.setPersonalId("850717-5019");
            person = (Person)this.personRepository.save(person);
            School school = new School();
            school.setName("School #1");
            school.setServices(new ServiceTypeEnum[]{ServiceTypeEnum.AFTER_SCHOOL_CENTER, ServiceTypeEnum.ELEMENTARY_SCHOOL, ServiceTypeEnum.SECONDARY_SCHOOL});
            school = (School)this.schoolRepository.save(school);
            SchoolClass schoolClass = new SchoolClass("A1-1", school, new Date(0, 0, 0, 8, 0), new Date(0, 0, 0, 15, 0));
            schoolClass = (SchoolClass)this.schoolClassRepository.save(schoolClass);
            SchoolClass schoolClass1 = new SchoolClass("A2-1", school, new Date(0, 0, 0, 12, 0), new Date(0, 0, 0, 18, 0));
            schoolClass1 = (SchoolClass)this.schoolClassRepository.save(schoolClass1);
            AcademicYear academicYear = new AcademicYear("2014-2015");
            academicYear = (AcademicYear)this.academicYearRepository.save(academicYear);
            Pupil pupil = new Pupil();
            pupil.setPerson(person);
            pupil.setSchoolClass(schoolClass);
            pupil.setAcademicYear(academicYear);
            pupil = (Pupil)this.pupilRepository.save(pupil);
        }
    }

    private void initializePersonJpa() {
    }

    private void initializeStatementJpa() {
        List applicationList = this.applicationRepository.findAll();
        if (applicationList.size() == 0) {
            Random random = new Random();
            for (int i = 0; i < 5; ++i) {
                Application application = new Application();
                application.setId((Serializable)Long.valueOf(i));
                application.setStatus(StatementStatus.values()[random.nextInt(StatementStatus.values().length)]);
                this.applicationRepository.save(application);
            }
        }
    }

    private void initializeToken() {
    }

    private void intializeSecurity() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        try {
            String sqlCheck = "(select authority from authorities  LIMIT 0, 1)UNION (SELECT  username FROM users limit 0, 1)";
            this.logger.info("Check Spring security tables...");
            List result = jdbcTemplate.queryForList(sqlCheck, String.class);
            if (result.size() < 2) {
                throw new Exception();
            }
            this.logger.info("Spring security tables is already exist.");
        }
        catch (Exception e) {
            try {
                this.logger.info("Creating Spring security tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/security_schema.ddl", (boolean)false);
                this.logger.info("Creating Spring security tables successful");
                this.logger.info("Filling Spring security tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/security_data.sql", (boolean)false);
                this.logger.info("Filling Spring security tables successful");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void intializeSecurityJpa() {
        this.logger.info("Check Spring security tables...");
        List roles = this.roleRepository.findAll();
        LinkedList<User> users = this.userRepository.findAll();
        if (users.size() == 0 || roles.size() == 0) {
            this.logger.info("User table has " + users.size() + " records");
            this.logger.info("Role table has " + roles.size() + " records");
            this.roleRepository.delete(roles);
            this.userRepository.delete(users);
            this.logger.info("Creating basic 4 roles...");
            Role roleAnonymous = (Role)this.roleRepository.save(new Role("ROLE_ANONYMOUS"));
            Role roleAdmin = (Role)this.roleRepository.save(new Role("ROLE_ADMIN"));
            Role roleUser = (Role)this.roleRepository.save(new Role("ROLE_USER"));
            Role roleDeveloper = (Role)this.roleRepository.save(new Role("ROLE_DEVELOPER"));
            Person adminPerson = new Person("1111", "John", "Admin");
            Person ivisPerson = new Person("2222", "Henry", "Ivis");
            Person userPerson = new Person("3333", "Sergey", "User");
            Person vitalyPerson = new Person("4444", "Vitaly", "Orlov");
            this.logger.info("Creating basic 4 users...");
            users = new LinkedList<User>();
            User user = new User("admin", "pass", new Role[]{roleAdmin, roleUser, roleDeveloper});
            user.setPerson(adminPerson);
            users.add(user);
            user = new User("ivis", "111", new Role[]{roleUser, roleDeveloper});
            user.setPerson(ivisPerson);
            users.add(user);
            user = new User("user", "111", new Role[]{roleUser});
            user.setPerson(userPerson);
            users.add(user);
            user = new User("vitaly", "", new Role[]{roleDeveloper});
            user.setPerson(vitalyPerson);
            users.add(user);
            this.userRepository.save(users);
        }
    }

    private void intializeOAuth2() {
        try {
            this.logger.info("Check OAuth2 tables...");
            this.clientDetailsService.listClientDetails();
            this.logger.info("OAuth2 tables is already exist.");
        }
        catch (Exception e) {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
            try {
                this.logger.info("Creating OAuth2 tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/oauth2_schema.ddl", (boolean)false);
                this.logger.info("Creating OAuth2 tables successful");
                this.logger.info("Filling OAuth2 tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/oauth2_data.sql", (boolean)false);
                this.logger.info("Filling OAuth2 tables successful");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void intializeOAuth2Jpa() {
        this.logger.info("Check OAuth2 tables...");
        List roles = this.clientRoleRepository.findAll();
        List clientDetailsList = this.clientDetailsService.findAll();
        if (roles.size() == 0 || clientDetailsList.size() == 0) {
            this.clientRoleRepository.delete(roles);
            this.clietnDetailsRepository.delete(clientDetailsList);
            this.logger.info("ClientRole table has " + roles.size() + " records");
            this.logger.info("ClientDetails table has " + clientDetailsList.size() + " records");
            this.logger.info("Creating basic 2 roles...");
            ClientRole role_admin = (ClientRole)this.clientRoleRepository.save(new ClientRole("ROLE_ADMIN"));
            ClientRole role_user = (ClientRole)this.clientRoleRepository.save(new ClientRole("ROLE_USER"));
            this.logger.info("Creating ClientRoles successful");
            this.logger.info("Creating basic 4 ClientDetails...");
            JpaClientDetails clientDetails = new JpaClientDetails();
            clientDetails.setName("ivis");
            clientDetails.setClientSecret("secret");
            clientDetails.setScope(new String[]{"read", "write", "execute"});
            clientDetails.setResourceIds("ivis");
            clientDetails.setOwner(this.userRepository.findByUsername("ivis"));
            clientDetails.setAuthoritiesOverload(this.clientRoleRepository.findAll());
            clientDetails.setAuthorizedGrantTypes(AuthorizedGrantType.authorization_code);
            clientDetails.setAccessTokenValiditySeconds(Integer.valueOf(60));
            clientDetails.setRefreshTokenValiditySeconds(Integer.valueOf(600));
            this.clietnDetailsRepository.save(clientDetails);
            clientDetails = new JpaClientDetails();
            clientDetails.setName("admin");
            clientDetails.setClientSecret("secret");
            clientDetails.setScope(new String[]{"read", "write", "execute"});
            clientDetails.setResourceIds("ivis");
            clientDetails.setOwner(this.userRepository.findByUsername("admin"));
            clientDetails.setAuthoritiesOverload(this.clientRoleRepository.findAll());
            clientDetails.setAuthorizedGrantTypes(new AuthorizedGrantType[]{AuthorizedGrantType.authorization_code, AuthorizedGrantType.client_credentials, AuthorizedGrantType.implicit, AuthorizedGrantType.password, AuthorizedGrantType.refresh_token});
            clientDetails.setAccessTokenValiditySeconds(Integer.valueOf(600));
            clientDetails.setRefreshTokenValiditySeconds(Integer.valueOf(6000));
            this.clietnDetailsRepository.save(clientDetails);
            this.logger.info("Creating ClientDetails successful");
        }
    }
}

