/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.oauth2.IvisClientDetailsService;
import java.security.Principal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdminController {
    @Autowired
    private ConsumerTokenServices tokenServices;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Value(value="${Hibernate.dialect}")
    private String test;

    @RequestMapping(value={"/oauth/users/{user}/tokens/{token}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> revokeToken(@PathVariable String user, @PathVariable String token, Principal principal) throws Exception {
        this.checkResourceOwner(user, principal);
        if (this.tokenServices.revokeToken(token)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/oauth/clients/{client}/tokens"})
    @ResponseBody
    public Collection<OAuth2AccessToken> listTokensForClient(@PathVariable String client) throws Exception {
        return this.tokenStore.findTokensByClientId(client);
    }

    @RequestMapping(value={"/oauth/tokens"}, method={RequestMethod.GET})
    public String tokenList(Model model) {
        IvisClientDetailsService ClientDetailsService2 = this.clientDetailsService;
        List clients = this.clientDetailsService.listClientDetails();
        LinkedList tokens = new LinkedList();
        for (ClientDetails clientDetails : clients) {
            Collection tokensByClientId = this.tokenStore.findTokensByClientId(clientDetails.getClientId());
            if (tokensByClientId == null) continue;
            tokens.addAll(tokensByClientId);
        }
        model.addAttribute("tokens", tokens);
        return "tokens";
    }

    @RequestMapping(value={"/oauth/tokens/{tokenVlue}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="tokenVlue") String tokenValue) {
        return this.tokenServices.revokeToken(tokenValue);
    }

    @RequestMapping(value={"/login"})
    public ModelAndView login(WebRequest webRequest, ModelAndView model) {
        boolean isPopup = this.isShowPopupLoginPage(webRequest);
        if (isPopup) {
            model.setViewName("security/login_popup");
        } else {
            model.setViewName("security/login");
        }
        return model;
    }

    private boolean isShowPopupLoginPage(WebRequest webRequest) {
        Map params;
        String[] display;
        boolean isPopup = false;
        SavedRequest savedRequest = (SavedRequest)webRequest.getAttribute("SPRING_SECURITY_SAVED_REQUEST", 2);
        if (savedRequest != null && (display = (String[])(params = savedRequest.getParameterMap()).get("display")) != null) {
            isPopup = "popup".equalsIgnoreCase(display[0]);
        }
        return isPopup;
    }

    @RequestMapping(value={"/", "/home", "index"})
    public String home() {
        return "default";
    }

    private void checkResourceOwner(String user, Principal principal) {
        OAuth2Authentication authentication;
        if (principal instanceof OAuth2Authentication && !(authentication = (OAuth2Authentication)principal).isClientOnly() && !user.equals(principal.getName())) {
            throw new AccessDeniedException(String.format("User '%s' cannot obtain tokens for user '%s'", principal.getName(), user));
        }
    }

    public void setTokenServices(ConsumerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setClientDetailsService(IvisClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

