/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.controllers.html.exceptions.NotFoundException;
import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.services.RoleService;
import com.imcode.services.UserService;
import com.imcode.validators.UserValidator;
import java.util.Locale;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/users"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserValidator userValidator;
    @Autowired
    MessageSource messageSource;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(ModelAndView model, Authentication authentication) {
        model.setViewName("users/list");
        model.addObject((Object)this.userService.findAll());
        return model;
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") Long id, ModelAndView model, WebRequest webRequest, Locale locale) {
        model.setViewName("users/edit");
        User user = (User)this.userService.find((Object)id);
        model.addObject((Object)user);
        model.addObject((Object)this.roleService.findAll());
        if (user == null) {
            model.setViewName("clients/list");
            throw new NotFoundException();
        }
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model) {
        model.setViewName("users/edit");
        model.addObject((Object)this.roleService.findAll());
        User user = new User();
        Role roleUser = this.roleService.findByName("ROLE_USER");
        model.addObject((Object)user);
        if (roleUser != null) {
            user.setAuthorities(roleUser);
        }
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView create(@ModelAttribute(value="user") @Valid User user, BindingResult bindingResultUser, ModelAndView model, WebRequest webRequest, Locale locale) {
        if (webRequest.isUserInRole("ROLE_ADMIN")) {
            user.setConfirmPassword(user.getPassword());
        }
        ValidationUtils.invokeValidator((Validator)this.userValidator, (Object)user, (Errors)bindingResultUser);
        if (this.userService.findByUsername(user.getUsername()) != null) {
            bindingResultUser.rejectValue("username", null, "User is alredy exists!");
        }
        if (bindingResultUser.hasErrors()) {
            model.addObject((Object)user);
            model.setViewName("users/edit");
            return model;
        }
        this.userService.save((Object)user);
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable(value="id") Long id, @ModelAttribute(value="user") @Valid User user, BindingResult bindingResultUser, ModelAndView model, WebRequest webRequest, Locale locale) {
        if (webRequest.isUserInRole("ROLE_ADMIN")) {
            user.setConfirmPassword(user.getPassword());
        }
        ValidationUtils.invokeValidator((Validator)this.userValidator, (Object)user, (Errors)bindingResultUser);
        if (bindingResultUser.hasErrors()) {
            model.addObject((Object)user);
            model.setViewName("users/edit");
            return model;
        }
        User persistUser = (User)this.userService.find((Object)id);
        if (persistUser == null) {
            throw new NotFoundException();
        }
        String fieldExceptions = user.getPassword().isEmpty() ? "id,password,confirmPassword" : "id";
        BeanUtils.copyProperties((Object)user, (Object)persistUser, (String[])new String[]{fieldExceptions});
        this.userService.save((Object)persistUser);
        model.setViewName("redirect:/users");
        return model;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) {
        if (!this.userService.exist((Object)id)) {
            throw new NotFoundException();
        }
        this.userService.delete((Object)id);
    }
}

