/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.controllers.html.form.Message;
import com.imcode.controllers.html.form.MessageType;
import com.imcode.entities.User;
import com.imcode.entities.enums.AuthorizedGrantType;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.services.ClientRoleService;
import com.imcode.services.UserService;
import com.imcode.validators.JpaClientDetailsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/clients"})
public class ClientDetailsControllerImpl {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Autowired
    private ClientRoleService clientRoleService;
    @Autowired
    private UserService userService;
    @Autowired
    private JpaClientDetailsValidator clientValidator;

    @RequestMapping(method={RequestMethod.GET})
    public String getAll(WebRequest webRequest, Model model, Authentication principal) {
        this.logger.info("Listing clients");
        List clientDetailsList = Collections.emptyList();
        if (webRequest.isUserInRole("ROLE_ADMIN")) {
            clientDetailsList = this.clientDetailsService.findAll();
        } else if (principal != null) {
            clientDetailsList = this.clientDetailsService.findAllUserClients((User)principal.getPrincipal());
        }
        model.addAttribute("clients", (Object)clientDetailsList);
        this.logger.info("No. of clients: " + clientDetailsList.size());
        return "clients/list";
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="id") String id, JpaClientDetails client, BindingResult bindingResult, Model uiModel, WebRequest webRequest, RedirectAttributes redirectAttributes, Authentication principal) {
        JpaClientDetails persistentClient;
        if (bindingResult.hasErrors()) {
            uiModel.addAttribute("message", (Object)new Message(MessageType.ERROR, "Client save fail"));
            uiModel.addAttribute("client", (Object)client);
            return "clients/edit";
        }
        uiModel.asMap().clear();
        redirectAttributes.addFlashAttribute("message", (Object)new Message(MessageType.SUCCESS, "Client save success"));
        if (webRequest.isUserInRole("ROLE_ADMIN")) {
            persistentClient = this.clientDetailsService.findOne(id);
        } else if (principal != null) {
            User user = (User)principal.getPrincipal();
            persistentClient = this.clientDetailsService.findUserClientById(id, user);
        } else {
            uiModel.addAttribute("message", (Object)new Message(MessageType.ERROR, "Client not found"));
            uiModel.addAttribute("client", (Object)client);
            return "clients/edit";
        }
        BeanUtils.copyProperties((Object)client, (Object)persistentClient, (String[])new String[]{"id"});
        this.clientDetailsService.updateClientDetails((ClientDetails)persistentClient);
        return "redirect:/clients";
    }

    @RequestMapping(value={"/{id}"}, params={"form"}, method={RequestMethod.GET})
    public ModelAndView updateForm(@PathVariable(value="id") String id, ModelAndView model, WebRequest webRequest, Authentication principal) {
        JpaClientDetails clientDetails;
        model.addObject((Object)this.userService.findAll());
        model.addObject((Object)this.clientRoleService.findAll());
        model.addObject("scopeList", (Object)"read,write,execute".split(","));
        model.addObject("grantTypes", Arrays.asList(AuthorizedGrantType.getRepresentations()));
        if (webRequest.isUserInRole("ROLE_ADMIN")) {
            clientDetails = this.clientDetailsService.findOne(id);
        } else if (principal != null) {
            clientDetails = this.clientDetailsService.findUserClientById(id, (User)principal.getPrincipal());
        } else {
            model.addObject("message", (Object)new Message(MessageType.ERROR, "Client not found"));
            model.setViewName("clients/list");
            return model;
        }
        model.addObject("client", (Object)clientDetails);
        model.setViewName("clients/edit");
        return model;
    }

    @RequestMapping(params={"form"}, method={RequestMethod.GET})
    public ModelAndView createForm(ModelAndView model, Authentication authentication) {
        model.addObject((Object)this.userService.findAll());
        model.addObject((Object)this.clientRoleService.findAll());
        model.addObject("scopeList", (Object)"read,write,execute".split(","));
        model.addObject("grantTypes", Arrays.asList(AuthorizedGrantType.getRepresentations()));
        JpaClientDetails client = new JpaClientDetails();
        client.setOwner((User)authentication.getPrincipal());
        model.addObject("client", (Object)client);
        model.setViewName("clients/edit");
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String create(JpaClientDetails client, BindingResult bindingResult, Model uiModel, RedirectAttributes redirectAttributes, WebRequest webRequest, Authentication principal) {
        if (bindingResult.hasErrors()) {
            uiModel.addAttribute("message", (Object)new Message(MessageType.ERROR, "Client save fail"));
            uiModel.addAttribute("client", (Object)client);
            return "clients/edit";
        }
        uiModel.asMap().clear();
        redirectAttributes.addFlashAttribute("message", (Object)new Message(MessageType.SUCCESS, "Client save success"));
        this.clientDetailsService.addClientDetails((ClientDetails)client);
        return "redirect:/clients";
    }
}

