/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.validators;

import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.services.RoleService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class UserValidator
implements Validator {
    @Autowired
    private RoleService roleService;

    public boolean supports(Class<?> clazz) {
        return User.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        User user = (User)target;
        HashSet<Role> roleSet = new HashSet<Role>();
        Set roleNameSet = user.getAuthorities();
        boolean hasErrors = false;
        for (Role role : roleNameSet) {
            Role persistRole = this.roleService.findByName(role.getName());
            if (persistRole != null) {
                roleSet.add(persistRole);
                continue;
            }
            hasErrors = true;
            errors.rejectValue("authorities", null, (Object[])new String[]{role.getName()}, "Role {1} not found.");
        }
        if (!hasErrors) {
            user.setAuthorities(roleSet);
        }
        if (!user.getPassword().equals(user.getConfirmPassword())) {
            errors.rejectValue("confirmPassword", "user.notmatchConfirmPassword");
        }
    }
}

