/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services.jpa;

import com.imcode.entities.User;
import com.imcode.repositories.UserRepository;
import com.imcode.services.AbstractService;
import com.imcode.services.UserService;
import java.util.Set;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserServiceRepoImpl
extends AbstractService<User, Long, UserRepository>
implements UserService {
    public User findByUsername(String username) {
        return ((UserRepository)this.getRepo()).findByUsername(username);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = ((UserRepository)this.getRepo()).findByUsername(username);
        if (user == null) {
            this.getLogger().debug("Query returned no results for user '" + username + "'");
            throw new UsernameNotFoundException(this.getMessageSource().getMessage("UserService.notFound", new Object[]{username}, "Username {0} not found", null));
        }
        Set roles = user.getAuthorities();
        if (roles == null || roles.size() == 0) {
            this.getLogger().debug("User '" + username + "' has no authorities and will be treated as 'not found'");
            throw new UsernameNotFoundException(this.getMessageSource().getMessage("UserService.noAuthority", new Object[]{username}, "User {0} has no GrantedAuthority", null));
        }
        return user;
    }
}

