/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.misc;

import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.enums.AuthorizedGrantType;
import com.imcode.entities.oauth2.ClientRole;
import com.imcode.entities.oauth2.JpaClientDetails;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.repositories.RoleRepository;
import com.imcode.repositories.UserRepository;
import com.imcode.repositories.oauth2.ClientRoleRepository;
import com.imcode.repositories.oauth2.ClietnDetailsRepository;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.test.jdbc.JdbcTestUtils;

@Service
public class Initializator {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Autowired
    private ClietnDetailsRepository clietnDetailsRepository;
    @Autowired
    private ClientRoleRepository clientRoleRepository;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void init() {
        this.intializeSecurityJpa();
        this.intializeOAuth2Jpa();
        this.initializeToken();
    }

    private void initializeToken() {
    }

    private void intializeSecurity() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        try {
            String sqlCheck = "(select authority from authorities  LIMIT 0, 1)UNION (SELECT  username FROM users limit 0, 1)";
            this.logger.info("Check Spring security tables...");
            List result = jdbcTemplate.queryForList(sqlCheck, String.class);
            if (result.size() < 2) {
                throw new Exception();
            }
            this.logger.info("Spring security tables is already exist.");
        }
        catch (Exception e) {
            try {
                this.logger.info("Creating Spring security tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/security_schema.ddl", (boolean)false);
                this.logger.info("Creating Spring security tables successful");
                this.logger.info("Filling Spring security tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/security_data.sql", (boolean)false);
                this.logger.info("Filling Spring security tables successful");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void intializeSecurityJpa() {
        this.logger.info("Check Spring security tables...");
        List roles = this.roleRepository.findAll();
        LinkedList<User> users = this.userRepository.findAll();
        if (users.size() == 0 || roles.size() == 0) {
            this.logger.info("User table has " + users.size() + " records");
            this.logger.info("Role table has " + roles.size() + " records");
            this.roleRepository.delete(roles);
            this.userRepository.delete(users);
            this.logger.info("Creating basic 4 roles...");
            Role roleAnonymous = (Role)this.roleRepository.save(new Role("ROLE_ANONYMOUS"));
            Role roleAdmin = (Role)this.roleRepository.save(new Role("ROLE_ADMIN"));
            Role roleUser = (Role)this.roleRepository.save(new Role("ROLE_USER"));
            Role roleDeveloper = (Role)this.roleRepository.save(new Role("ROLE_DEVELOPER"));
            this.logger.info("Creating basic 4 users...");
            users = new LinkedList<User>();
            users.add(new User("admin", "pass", new Role[]{roleAdmin, roleUser, roleDeveloper}));
            users.add(new User("ivis", "111", new Role[]{roleUser, roleDeveloper}));
            users.add(new User("user", "111", new Role[]{roleUser}));
            users.add(new User("vitaly", "", new Role[]{roleDeveloper}));
            this.userRepository.save(users);
        }
    }

    private void intializeOAuth2() {
        try {
            this.logger.info("Check OAuth2 tables...");
            this.clientDetailsService.listClientDetails();
            this.logger.info("OAuth2 tables is already exist.");
        }
        catch (Exception e) {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
            try {
                this.logger.info("Creating OAuth2 tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/oauth2_schema.ddl", (boolean)false);
                this.logger.info("Creating OAuth2 tables successful");
                this.logger.info("Filling OAuth2 tables");
                JdbcTestUtils.executeSqlScript((JdbcTemplate)jdbcTemplate, (ResourceLoader)this.resourceLoader, (String)"classpath:sql/oauth2_data.sql", (boolean)false);
                this.logger.info("Filling OAuth2 tables successful");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void intializeOAuth2Jpa() {
        this.logger.info("Check OAuth2 tables...");
        List roles = this.clientRoleRepository.findAll();
        List clientDetailsList = this.clientDetailsService.findAll();
        if (roles.size() == 0 || clientDetailsList.size() == 0) {
            this.clientRoleRepository.delete(roles);
            this.clietnDetailsRepository.delete(clientDetailsList);
            this.logger.info("ClientRole table has " + roles.size() + " records");
            this.logger.info("ClientDetails table has " + clientDetailsList.size() + " records");
            this.logger.info("Creating basic 2 roles...");
            ClientRole role_admin = (ClientRole)this.clientRoleRepository.save(new ClientRole("ROLE_ADMIN"));
            ClientRole role_user = (ClientRole)this.clientRoleRepository.save(new ClientRole("ROLE_USER"));
            this.logger.info("Creating ClientRoles successful");
            this.logger.info("Creating basic 4 ClientDetails...");
            JpaClientDetails clientDetails = new JpaClientDetails();
            clientDetails.setName("ivis");
            clientDetails.setClientSecret("secret");
            clientDetails.setScope(new String[]{"read", "write", "execute"});
            clientDetails.setResourceIds("ivis");
            clientDetails.setOwner(this.userRepository.findByUsername("ivis"));
            clientDetails.setAuthorities((Collection)this.clientRoleRepository.findAll());
            clientDetails.setAuthorizedGrantTypes(AuthorizedGrantType.AUTHORIZATION_CODE);
            clientDetails.setAccessTokenValiditySeconds(Integer.valueOf(60));
            clientDetails.setRefreshTokenValiditySeconds(Integer.valueOf(600));
            this.clietnDetailsRepository.save(clientDetails);
            clientDetails = new JpaClientDetails();
            clientDetails.setName("admin");
            clientDetails.setClientSecret("secret");
            clientDetails.setScope(new String[]{"read", "write", "execute"});
            clientDetails.setResourceIds("ivis");
            clientDetails.setOwner(this.userRepository.findByUsername("admin"));
            clientDetails.setAuthorities((Collection)this.clientRoleRepository.findAll());
            clientDetails.setAuthorizedGrantTypes(new AuthorizedGrantType[]{AuthorizedGrantType.AUTHORIZATION_CODE, AuthorizedGrantType.CLIENT_CREDENTIALS, AuthorizedGrantType.IMPLICIT, AuthorizedGrantType.PASSWORD, AuthorizedGrantType.REFRESH_TOKEN});
            clientDetails.setAccessTokenValiditySeconds(Integer.valueOf(600));
            clientDetails.setRefreshTokenValiditySeconds(Integer.valueOf(6000));
            this.clietnDetailsRepository.save(clientDetails);
            this.logger.info("Creating ClientDetails successful");
        }
    }
}

