/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.services.jdbc;

import com.imcode.services.ApplicationService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;

public class JdbcApplicationServiceImpl
implements ApplicationService {
    private JdbcClientDetailsService jdbcClientDetailsService;

    public ClientDetails save(ClientDetails entity) {
        this.jdbcClientDetailsService.addClientDetails(entity);
        return entity;
    }

    public BaseClientDetails find(String s) {
        return (BaseClientDetails)this.jdbcClientDetailsService.loadClientByClientId(s);
    }

    public boolean exist(String s) {
        return this.find(s) != null;
    }

    public void delete(String s) {
        this.jdbcClientDetailsService.removeClientDetails(s);
    }

    public List<ClientDetails> findAll() {
        return this.jdbcClientDetailsService.listClientDetails();
    }

    public List<ClientDetails> findAllUserApplications(String userId) {
        LinkedList<ClientDetails> userApplications = new LinkedList<ClientDetails>();
        List<ClientDetails> allApplications = this.findAll();
        if (allApplications != null) {
            for (ClientDetails clientDetails : allApplications) {
                if (!this.isUserApplication(clientDetails, userId)) continue;
                userApplications.add(clientDetails);
            }
        }
        return userApplications;
    }

    public BaseClientDetails findUserApplication(String id, String userId) {
        BaseClientDetails result = null;
        BaseClientDetails clientDetails = (BaseClientDetails)this.jdbcClientDetailsService.loadClientByClientId(id);
        if (clientDetails != null && this.isUserApplication((ClientDetails)clientDetails, userId)) {
            result = clientDetails;
        }
        return result;
    }

    private boolean isUserApplication(ClientDetails clientDetails, String userId) {
        String ownerId;
        Map additionalInfo = clientDetails.getAdditionalInformation();
        return additionalInfo != null && (ownerId = (String)additionalInfo.get("user")) != null && userId.equalsIgnoreCase(ownerId);
    }
}

