/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.utils.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CollectionBuilder<T> {
    private Collection<T> collection;
    private Class<?> clazz;
    private boolean needAdd = true;

    public static <T> List<T> asList(T ... elems) {
        return (List)super.addAll(elems);
    }

    public static <T> List<T> asLinkedList(T ... elems) {
        return (List)super.addAll(elems);
    }

    public static <T> Set<T> asSet(T ... elems) {
        return (Set)super.addAll(elems);
    }

    public static <T> Set<T> asLinkedSet(T ... elems) {
        return (Set)super.addAll(elems);
    }

    public static <T> CollectionBuilder<T> initList() {
        return CollectionBuilder.initCol(new ArrayList());
    }

    public static <T> CollectionBuilder<T> initLinkedList() {
        return CollectionBuilder.initCol(new LinkedList());
    }

    public static <T> CollectionBuilder<T> initSet() {
        return CollectionBuilder.initCol(new HashSet());
    }

    public static <T> CollectionBuilder<T> initLinkedSet() {
        return CollectionBuilder.initCol(new LinkedHashSet());
    }

    public CollectionBuilder<T> add(T e) {
        if (this.needAdd) {
            this.collection.add(e);
        } else {
            this.needAdd = true;
        }
        return this;
    }

    public CollectionBuilder<T> needNext(boolean flag) {
        this.needAdd = flag;
        return this;
    }

    public Collection<T> build() {
        return this.collection;
    }

    public List<T> buildList() {
        assert (this.collection instanceof List) : "It is not a list";
        return (List)this.collection;
    }

    public Set<T> buildSet() {
        assert (this.collection instanceof Set) : "It is not a set";
        return (Set)this.collection;
    }

    public CollectionBuilder<T> setClass(Class<?> clazz) {
        assert (clazz == null) : "Class was set.";
        this.clazz = clazz;
        return this;
    }

    public CollectionBuilder<T> constructAndAdd(Object ... initArgs) {
        if (this.needAdd) {
            Object instance;
            Class[] classArgs = (Class[])super.addAll(initArgs).stream().map(Object::getClass).toArray(Class[]::new);
            try {
                instance = this.clazz.getConstructor(classArgs).newInstance(initArgs);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not construct object. Arguments not valid");
            }
            this.collection.add(instance);
        } else {
            this.needAdd = true;
        }
        return this;
    }

    private CollectionBuilder() {
    }

    private static <T> CollectionBuilder<T> initCol(Collection<T> collection) {
        CollectionBuilder<T> builder = new CollectionBuilder<T>();
        builder.collection = collection;
        return builder;
    }

    private Collection<T> addAll(T ... elems) {
        Collections.addAll(this.collection, elems);
        return this.collection;
    }
}

