/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.converters;

import com.imcode.entities.superclasses.AbstractIdEntity;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.ServiceInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IvisIdToDomainClassConverter<T extends ConversionService & ConverterRegistry>
implements ConditionalGenericConverter,
ApplicationContextAware {
    private final T conversionService;
    private IvisServiceFactory serviceFactory;
    private ToEntityConverter toEntityConverter;

    public IvisIdToDomainClassConverter(T conversionService) {
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.toEntityConverter.convert(source, sourceType, targetType);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.toEntityConverter.matches(sourceType, targetType);
        }
        catch (ConversionMatchAbbreviationException o_O) {
            return false;
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        this.serviceFactory = (IvisServiceFactory)context.getBean(IvisServiceFactory.class);
        this.toEntityConverter = new ToEntityConverter();
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this.toEntityConverter);
    }

    private static final class ConversionMatchAbbreviationException
    extends RuntimeException {
        private ConversionMatchAbbreviationException() {
        }
    }

    private class ToEntityConverter
    implements ConditionalGenericConverter {
        private ToEntityConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString()) && !sourceType.equals((Object)targetType)) {
                return null;
            }
            if (sourceType.equals((Object)targetType)) {
                return source;
            }
            Class domainType = targetType.getType();
            ServiceInfo serviceInfo = IvisIdToDomainClassConverter.this.serviceFactory.getServiceInfoFor(domainType);
            Object id = IvisIdToDomainClassConverter.this.conversionService.convert(source, serviceInfo.getIdClass());
            try {
                Object instance = targetType.getObjectType().newInstance();
                AbstractIdEntity abstractIdEntity = (AbstractIdEntity)instance;
                abstractIdEntity.setId((Serializable)id);
                return abstractIdEntity;
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!IvisIdToDomainClassConverter.this.serviceFactory.hasServiceFor(targetType.getType())) {
                return false;
            }
            if (sourceType.equals((Object)targetType)) {
                return true;
            }
            Class rawIdType = IvisIdToDomainClassConverter.this.serviceFactory.getServiceInfoFor(targetType.getType()).getIdClass();
            return sourceType.equals((Object)TypeDescriptor.valueOf(rawIdType)) || IvisIdToDomainClassConverter.this.conversionService.canConvert(sourceType.getType(), rawIdType);
        }
    }
}

