/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.utils;

import com.imcode.entities.Person;
import com.imcode.entities.User;
import com.imcode.services.UserService;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.ProxyIvisServiceFactory;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class IvisOAuth2Utils {
    private static final Logger logger = LoggerFactory.getLogger(IvisOAuth2Utils.class);
    public static final String CLIENT_CONTEXT_PARAMETER_NAME = "oauth2ClientContext";
    public static final String LOGGED_IN_USER_PARAMETER_NAME = "loggedInUser";
    public static final String IVIS_SERVICE_FACTORY_PARAMETER_NAME = "ivisServiceFactory";

    public static OAuth2ClientContext getClientContext(HttpServletRequest request) {
        return IvisOAuth2Utils.getClientContext(request.getSession(true));
    }

    public static OAuth2ClientContext getClientContext(HttpSession session) {
        OAuth2ClientContext clientContext = (OAuth2ClientContext)session.getAttribute(CLIENT_CONTEXT_PARAMETER_NAME);
        if (clientContext == null) {
            clientContext = new DefaultOAuth2ClientContext();
            session.setAttribute(CLIENT_CONTEXT_PARAMETER_NAME, (Object)clientContext);
        }
        return clientContext;
    }

    public static void setAccessToken(HttpSession session, OAuth2AccessToken accessToken) {
        OAuth2ClientContext clientContext = IvisOAuth2Utils.getClientContext(session);
        clientContext.setAccessToken(accessToken);
    }

    public static void setAccessToken(HttpServletRequest request, OAuth2AccessToken accessToken) {
        IvisOAuth2Utils.setAccessToken(request.getSession(true), accessToken);
    }

    public static OAuth2AccessToken getAccessToken(HttpServletRequest request) {
        return IvisOAuth2Utils.getAccessToken(request.getSession(true));
    }

    public static OAuth2AccessToken getAccessToken(HttpSession session) {
        OAuth2AccessToken accessToken = null;
        OAuth2ClientContext clientContext = IvisOAuth2Utils.getClientContext(session);
        if (clientContext != null) {
            accessToken = clientContext.getAccessToken();
        }
        return accessToken;
    }

    public static OAuth2AccessToken getAccessToken(AuthorizationCodeResourceDetails client, String code, String redirectUri) throws UnsupportedEncodingException {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"authorization_code");
        form.add((Object)"code", (Object)code);
        form.add((Object)"redirect_uri", (Object)redirectUri);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", String.format("Basic %s", new String(Base64.encode((byte[])String.format("%s:%s", client.getClientId(), client.getClientSecret()).getBytes("UTF-8")), "UTF-8")));
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity result = restTemplate.postForEntity(client.getAccessTokenUri(), (Object)httpEntity, OAuth2AccessToken.class, new Object[0]);
            return (OAuth2AccessToken)result.getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OAuth2AccessToken getAccessToken(AuthorizationCodeResourceDetails client, String refreshToken) throws UnsupportedEncodingException {
        if (refreshToken == null || refreshToken.isEmpty()) {
            return null;
        }
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"refresh_token");
        form.add((Object)"refresh_token", (Object)refreshToken);
        form.add((Object)"client_id", (Object)client.getId());
        form.add((Object)"client_secret", (Object)client.getClientSecret());
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity result = restTemplate.postForEntity(client.getAccessTokenUri(), (Object)httpEntity, OAuth2AccessToken.class, new Object[0]);
            return (OAuth2AccessToken)result.getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isTokenGood(HttpServletRequest request) {
        OAuth2AccessToken accessToken = IvisOAuth2Utils.getAccessToken(request);
        return accessToken != null && !accessToken.isExpired();
    }

    public static User getIvisLoggedInUser(HttpServletRequest request) {
        return IvisOAuth2Utils.isTokenGood(request) ? IvisOAuth2Utils.getIvisLoggedInUser(request.getSession(true)) : null;
    }

    private static User getIvisLoggedInUser(HttpSession session) {
        Object user = session.getAttribute(LOGGED_IN_USER_PARAMETER_NAME);
        try {
            if (user != null) {
                return user instanceof User ? (User)user : null;
            }
            User currentUser = IvisOAuth2Utils.getServiceFactory(session).getService(UserService.class).getCurrentUser();
            if (currentUser == null) {
                return currentUser;
            }
            IvisOAuth2Utils.loginUser(session, currentUser);
            return currentUser;
        }
        catch (Exception e) {
            logger.error("Error has occurred: ", (Throwable)e);
            return new User();
        }
    }

    private static void loginUser(HttpSession session, User user) {
        session.setAttribute(LOGGED_IN_USER_PARAMETER_NAME, (Object)user);
    }

    public static String getOAuth2AuthirizationUrl(AuthorizationCodeResourceDetails client, String redirectUri) throws URISyntaxException {
        return IvisOAuth2Utils.getOAuth2AuthirizationUrl(client, redirectUri, true);
    }

    public static String getOAuth2AuthirizationUrl(AuthorizationCodeResourceDetails client, String redirectUri, boolean isPopup) throws URISyntaxException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("response_type", "code"));
        parameters.add(new BasicNameValuePair("client_id", client.getClientId()));
        parameters.add(new BasicNameValuePair("redirect_uri", redirectUri));
        if (isPopup) {
            parameters.add(new BasicNameValuePair("display", "popup"));
        }
        if (client.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List scope = client.getScope();
            if (scope != null) {
                Iterator scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append((String)scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            parameters.add(new BasicNameValuePair("scope", builder.toString()));
        }
        URIBuilder uriBuilder = new URIBuilder(client.getUserAuthorizationUri());
        uriBuilder.addParameters(parameters);
        return uriBuilder.toString();
    }

    public static IvisServiceFactory getServiceFactory(HttpSession session) {
        ProxyIvisServiceFactory serviceFactory = (ProxyIvisServiceFactory)session.getAttribute(IVIS_SERVICE_FACTORY_PARAMETER_NAME);
        if (serviceFactory == null) {
            ApplicationContext ctx = IvisOAuth2Utils.getSpringContext(session);
            ProxyIvisServiceFactory serviceFactoryTemplate = (ProxyIvisServiceFactory)ctx.getBean(ProxyIvisServiceFactory.class);
            OAuth2ProtectedResourceDetails clientDetails = (OAuth2ProtectedResourceDetails)ctx.getBean(OAuth2ProtectedResourceDetails.class);
            serviceFactory = new ProxyIvisServiceFactory(serviceFactoryTemplate.getApiUrl(), IvisOAuth2Utils.getClientContext(session), clientDetails);
            serviceFactory.initialize();
            session.setAttribute(IVIS_SERVICE_FACTORY_PARAMETER_NAME, (Object)serviceFactory);
        }
        return serviceFactory;
    }

    public static IvisServiceFactory getServiceFactory(HttpServletRequest request) {
        return IvisOAuth2Utils.getServiceFactory(request.getSession(true));
    }

    public static ApplicationContext getSpringContext(HttpServletRequest request) {
        return IvisOAuth2Utils.getSpringContext(request.getSession(true));
    }

    public static ApplicationContext getSpringContext(HttpSession session) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)session.getServletContext());
    }

    public static ServiceAddressBuilder getServiceAddressBuilder() {
        return new ServiceAddressBuilder();
    }

    public static void setRefreshTokenAsCokie(HttpServletResponse response, OAuth2RefreshToken token, int expiry) {
        Cookie cookie = new Cookie("refreshToken", token.getValue());
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
    }

    public static boolean personContainsString(Person person, String searchText) {
        return person != null && (StringUtils.containsIgnoreCase((CharSequence)person.getPersonalId(), (CharSequence)searchText) || StringUtils.containsIgnoreCase((CharSequence)person.getFirstName(), (CharSequence)searchText) || StringUtils.containsIgnoreCase((CharSequence)person.getLastName(), (CharSequence)searchText));
    }

    public static class ServiceAddressBuilder {
        private boolean builded;
        private String endPointUrl = "http://ivis.dev.imcode.com";
        private String version = "v1";
        private String responseType = "json";

        public ServiceAddressBuilder endPointUrl(String endPointUrl) {
            this.checkForBuilded();
            this.endPointUrl = endPointUrl;
            return this;
        }

        public ServiceAddressBuilder version(String version) {
            this.checkForBuilded();
            this.version = version;
            return this;
        }

        public ServiceAddressBuilder responseType(String responseType) {
            this.checkForBuilded();
            this.responseType = responseType;
            return this;
        }

        public String toString() {
            Pattern pattern = Pattern.compile("./$");
            this.endPointUrl = pattern.matcher(this.endPointUrl).replaceAll("");
            this.version = pattern.matcher(this.version).replaceAll("");
            this.responseType = pattern.matcher(this.responseType).replaceAll("");
            this.builded = true;
            return String.format("%s/api/%s/%s/", this.endPointUrl, this.version, this.responseType);
        }

        private void checkForBuilded() {
            if (this.builded) {
                throw new RuntimeException("This builder is allredy builded!");
            }
        }

        public boolean isBuilded() {
            return this.builded;
        }

        public String getEndPointUrl() {
            return this.endPointUrl;
        }

        public String getVersion() {
            return this.version;
        }

        public String getResponseType() {
            return this.responseType;
        }
    }
}

