/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.filter;

import imcode.services.utils.IvisOAuth2Utils;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedUserException;

public class IvisAuthorizedFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(IvisAuthorizedFilter.class);
    private String roles;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.roles = filterConfig.getInitParameter("roles");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest;
        try {
            servletRequest = (HttpServletRequest)request;
        }
        catch (ClassCastException e) {
            return;
        }
        logger.info("Access to protected resources.");
        if (!IvisOAuth2Utils.isTokenGood(servletRequest)) {
            throw new UnauthorizedUserException("Token isn't good.");
        }
        if (Objects.nonNull(this.roles) && !IvisOAuth2Utils.getIvisLoggedInUser(servletRequest).hasRoles(this.roles.split(","))) {
            throw new AccessDeniedException("Token is good, but roles aren't.");
        }
        logger.info("Access is permitted");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

