/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.filter;

import imcode.services.utils.IvisOAuth2Utils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IvisAuthorizedFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(IvisAuthorizedFilter.class);
    private String roles;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.roles = filterConfig.getInitParameter("roles");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse servletResponse;
        HttpServletRequest servletRequest;
        try {
            servletRequest = (HttpServletRequest)request;
            servletResponse = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            return;
        }
        logger.debug("Access to protected resources.");
        if (!IvisOAuth2Utils.isTokenGood(servletRequest)) {
            servletResponse.setStatus(401);
            logger.info("Token no good.");
        } else if (this.roles == null) {
            servletResponse.setStatus(servletResponse.getStatus());
            logger.info("Token good not need use roles.");
        } else if (IvisOAuth2Utils.getIvisLoggedInUser(servletRequest).hasRoles(this.roles.split(","))) {
            logger.info("Token and roles good.");
            servletResponse.setStatus(servletResponse.getStatus());
        } else {
            logger.info("Token good, but roles aren't.");
            servletResponse.setStatus(401);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

