/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.filter;

import imcode.services.utils.IvisOAuth2Utils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IvisAuthorizedFilter
implements Filter {
    private String roles;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.roles = filterConfig.getInitParameter("roles");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse servletResponse;
        HttpServletRequest servletRequest;
        try {
            servletRequest = (HttpServletRequest)request;
            servletResponse = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            return;
        }
        if (!IvisOAuth2Utils.isTokenGood(servletRequest)) {
            servletResponse.setStatus(401);
        } else if (this.roles == null) {
            servletResponse.setStatus(servletResponse.getStatus());
        } else if (IvisOAuth2Utils.getIvisLoggedInUser(servletRequest).hasRoles(this.roles.split(","))) {
            servletResponse.setStatus(servletResponse.getStatus());
        } else {
            servletResponse.setStatus(401);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

