/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.exceptionhandling;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import imcode.services.exceptionhandling.GeneralException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth2.client.http.OAuth2ErrorHandler;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

public class IvisResponseErrorHandler
extends OAuth2ErrorHandler {
    public IvisResponseErrorHandler(OAuth2ProtectedResourceDetails resource) {
        super(resource);
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return response.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR || response.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException, GeneralException {
        switch (response.getStatusCode()) {
            case BAD_REQUEST: {
                throw this.buildException(response.getBody());
            }
            case UNAUTHORIZED: {
                throw this.buildException(response.getBody());
            }
            case FORBIDDEN: {
                throw this.buildException(response.getBody());
            }
        }
        super.handleError(response);
    }

    private GeneralException buildException(InputStream responseBody) throws IOException {
        return (GeneralException)new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).readValue(responseBody, GeneralException.class);
    }
}

