/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.utils;

import com.imcode.entities.Person;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.ProxyIvisServiceFactory;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.context.ApplicationContext;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class IvisOAuth2Utils {
    public static final String CLIENT_CONTEXT_PARAMETER_NAME = "oauth2ClientContext";
    public static final String IVIS_SERVICE_FACTORY_PARAMETER_NAME = "ivisServiceFactory";

    public static OAuth2ClientContext getClientContext(HttpServletRequest request) {
        return IvisOAuth2Utils.getClientContext(request.getSession(true));
    }

    public static OAuth2ClientContext getClientContext(HttpSession session) {
        OAuth2ClientContext clientContext = (OAuth2ClientContext)session.getAttribute(CLIENT_CONTEXT_PARAMETER_NAME);
        if (clientContext == null) {
            clientContext = new DefaultOAuth2ClientContext();
            session.setAttribute(CLIENT_CONTEXT_PARAMETER_NAME, (Object)clientContext);
        }
        return clientContext;
    }

    public static void setAccessToken(HttpSession session, OAuth2AccessToken accessToken) {
        OAuth2ClientContext clientContext = IvisOAuth2Utils.getClientContext(session);
        clientContext.setAccessToken(accessToken);
    }

    public static void setAccessToken(HttpServletRequest request, OAuth2AccessToken accessToken) {
        IvisOAuth2Utils.setAccessToken(request.getSession(true), accessToken);
    }

    public static OAuth2AccessToken getAccessToken(HttpServletRequest request) {
        return IvisOAuth2Utils.getAccessToken(request.getSession(true));
    }

    public static OAuth2AccessToken getAccessToken(HttpSession session) {
        OAuth2AccessToken accessToken = null;
        OAuth2ClientContext clientContext = IvisOAuth2Utils.getClientContext(session);
        if (clientContext != null) {
            accessToken = clientContext.getAccessToken();
        }
        return accessToken;
    }

    public static boolean isTokenGood(HttpServletRequest request) {
        OAuth2AccessToken accessToken = IvisOAuth2Utils.getAccessToken(request);
        return accessToken != null && !accessToken.isExpired();
    }

    public static String getOAuth2AuthirizationUrl(AuthorizationCodeResourceDetails client, String redirectUri) throws URISyntaxException {
        return IvisOAuth2Utils.getOAuth2AuthirizationUrl(client, redirectUri, true);
    }

    public static String getOAuth2AuthirizationUrl(AuthorizationCodeResourceDetails client, String redirectUri, boolean isPopup) throws URISyntaxException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("response_type", "code"));
        parameters.add(new BasicNameValuePair("client_id", client.getClientId()));
        parameters.add(new BasicNameValuePair("redirect_uri", redirectUri));
        if (isPopup) {
            parameters.add(new BasicNameValuePair("display", "popup"));
        }
        if (client.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List scope = client.getScope();
            if (scope != null) {
                Iterator scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append((String)scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            parameters.add(new BasicNameValuePair("scope", builder.toString()));
        }
        URIBuilder uriBuilder = new URIBuilder(client.getUserAuthorizationUri());
        uriBuilder.addParameters(parameters);
        return uriBuilder.toString();
    }

    public static IvisServiceFactory getServiceFactory(HttpSession session) {
        ProxyIvisServiceFactory serviceFactory = (ProxyIvisServiceFactory)session.getAttribute(IVIS_SERVICE_FACTORY_PARAMETER_NAME);
        if (serviceFactory == null) {
            ApplicationContext ctx = IvisOAuth2Utils.getSpringContext(session);
            ProxyIvisServiceFactory serviceFactoryTemplate = (ProxyIvisServiceFactory)ctx.getBean(ProxyIvisServiceFactory.class);
            OAuth2ProtectedResourceDetails clientDetails = (OAuth2ProtectedResourceDetails)ctx.getBean(OAuth2ProtectedResourceDetails.class);
            serviceFactory = new ProxyIvisServiceFactory(serviceFactoryTemplate.getApiUrl(), IvisOAuth2Utils.getClientContext(session), clientDetails);
            serviceFactory.initialize();
            session.setAttribute(IVIS_SERVICE_FACTORY_PARAMETER_NAME, (Object)serviceFactory);
        }
        return serviceFactory;
    }

    public static IvisServiceFactory getServiceFactory(HttpServletRequest request) {
        return IvisOAuth2Utils.getServiceFactory(request.getSession(true));
    }

    public static ApplicationContext getSpringContext(HttpServletRequest request) {
        return IvisOAuth2Utils.getSpringContext(request.getSession(true));
    }

    public static ApplicationContext getSpringContext(HttpSession session) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)session.getServletContext());
    }

    public static ServiceAddressBuilder getServiceAddressBuilder() {
        return new ServiceAddressBuilder();
    }

    public static boolean personContainsString(Person person, String searchText) {
        return person != null && (StringUtils.containsIgnoreCase((CharSequence)person.getPersonalId(), (CharSequence)searchText) || StringUtils.containsIgnoreCase((CharSequence)person.getFirstName(), (CharSequence)searchText) || StringUtils.containsIgnoreCase((CharSequence)person.getLastName(), (CharSequence)searchText));
    }

    public static class ServiceAddressBuilder {
        private boolean builded;
        private String endPointUrl = "http://ivis.dev.imcode.com";
        private String version = "v1";
        private String responseType = "json";

        public ServiceAddressBuilder endPointUrl(String endPointUrl) {
            this.checkForBuilded();
            this.endPointUrl = endPointUrl;
            return this;
        }

        public ServiceAddressBuilder version(String version) {
            this.checkForBuilded();
            this.version = version;
            return this;
        }

        public ServiceAddressBuilder responseType(String responseType) {
            this.checkForBuilded();
            this.responseType = responseType;
            return this;
        }

        public String toString() {
            Pattern pattern = Pattern.compile("./$");
            this.endPointUrl = pattern.matcher(this.endPointUrl).replaceAll("");
            this.version = pattern.matcher(this.version).replaceAll("");
            this.responseType = pattern.matcher(this.responseType).replaceAll("");
            this.builded = true;
            return String.format("%s/api/%s/%s/", this.endPointUrl, this.version, this.responseType);
        }

        private void checkForBuilded() {
            if (this.builded) {
                throw new RuntimeException("This builder is allredy builded!");
            }
        }

        public boolean isBuilded() {
            return this.builded;
        }

        public String getEndPointUrl() {
            return this.endPointUrl;
        }

        public String getVersion() {
            return this.version;
        }

        public String getResponseType() {
            return this.responseType;
        }
    }
}

