/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.entities.superclasses.AbstractIdEntity;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.AbstractOAuth2Service;
import imcode.services.restful.ProxyIvisServiceFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

public class ProxyIvisServiceFactoryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ProxyIvisServiceFactoryBuilder.class);
    public static final String DEFAULT_ENTITY_PACKEDGE = "com.imcode.entities";
    public static final String DEFAULT_SERVICE_PACKEDGE = "imcode.services.restful";
    private String apiUrl;
    private OAuth2ClientContext clientContext = new DefaultOAuth2ClientContext();
    private OAuth2ProtectedResourceDetails client;
    private Set<Class<? extends AbstractIdEntity>> entityClassSet = new HashSet<Class<? extends AbstractIdEntity>>();
    private Set<AbstractOAuth2Service> serviceInstanceSet = new HashSet<AbstractOAuth2Service>();
    private Set<Class<AbstractOAuth2Service>> serviceClassSet = new HashSet<Class<AbstractOAuth2Service>>();
    private String entityPackage = "com.imcode.entities";
    private String servicePackage = "imcode.services.restful";

    public ProxyIvisServiceFactoryBuilder setApiUrl(String apiUrl) {
        Objects.requireNonNull(this.entityClassSet);
        this.apiUrl = apiUrl;
        return this;
    }

    public ProxyIvisServiceFactoryBuilder setClientContext(OAuth2ClientContext clientContext) {
        Objects.requireNonNull(this.entityClassSet);
        this.clientContext = clientContext;
        return this;
    }

    public ProxyIvisServiceFactoryBuilder setClient(OAuth2ProtectedResourceDetails client) {
        Objects.requireNonNull(this.entityClassSet);
        this.client = client;
        return this;
    }

    public ProxyIvisServiceFactoryBuilder setEntityClassSet(Set<Class<? extends AbstractIdEntity>> entityClassSet) {
        Objects.requireNonNull(entityClassSet);
        this.entityClassSet = entityClassSet;
        return this;
    }

    public ProxyIvisServiceFactoryBuilder setServiceClassSet(Set<Class<AbstractOAuth2Service>> serviceClassSet) {
        Objects.requireNonNull(this.entityClassSet);
        this.serviceClassSet = serviceClassSet;
        return this;
    }

    public ProxyIvisServiceFactoryBuilder setEntityPackage(String entityPackage) {
        this.entityPackage = entityPackage;
        return this;
    }

    public ProxyIvisServiceFactoryBuilder setServicePackage(String servicePackage) {
        this.servicePackage = servicePackage;
        return this;
    }

    private void checkMandatoryFields() {
        if (this.apiUrl == null) {
            throw new IllegalStateException();
        }
        if (this.clientContext == null) {
            throw new IllegalStateException();
        }
        if (this.client == null) {
            throw new IllegalStateException();
        }
    }

    private <T> Set<Class<T>> getClasses(String packages, Class<T> baseClass) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(baseClass));
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{packages})) {
            String[] packageArray;
            for (String pack : packageArray = packages.split("[^\\w.]+")) {
                Set beanDefinitions = scanner.findCandidateComponents(packages);
                for (BeanDefinition beanDefinition : beanDefinitions) {
                    String className = "";
                    try {
                        className = beanDefinition.getBeanClassName();
                        Class<?> clazz = Class.forName(className);
                        result.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Unable to load class \"" + className + "\"");
                    }
                }
            }
        }
        return result;
    }

    private void addServiceInstances(ProxyIvisServiceFactory factory, String packages) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{packages})) {
            Set<Class<AbstractOAuth2Service>> serviceClasses = this.getClasses(packages, AbstractOAuth2Service.class);
            for (Class<AbstractOAuth2Service> serviceClass : serviceClasses) {
                this.addServiceInstance(factory, serviceClass);
            }
        }
    }

    private void addServiceInstance(ProxyIvisServiceFactory factory, Class<AbstractOAuth2Service> serviceClass) {
        try {
            Class entityClass = ProxyIvisServiceFactoryBuilder.getClassOfTypeArgument(serviceClass, 0);
            Constructor<AbstractOAuth2Service> constructor = serviceClass.getConstructor(IvisServiceFactory.class, String.class);
            AbstractOAuth2Service instance = constructor.newInstance(factory, this.getDefaultServiceAlias(entityClass));
            factory.addService(instance);
        }
        catch (InstantiationException e) {
            logger.error("Unable to create instance of class \"" + serviceClass + "\"");
        }
        catch (NoSuchMethodException e) {
            logger.error("Constructor not fuond \"" + serviceClass + "\"");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private String getDefaultServiceAlias(Class<? extends AbstractIdEntity> serviseClass) {
        StringBuilder sb = new StringBuilder(this.apiUrl).append('/').append(serviseClass.getSimpleName().toLowerCase());
        char lastLater = sb.charAt(sb.length() - 1);
        switch (lastLater) {
            case 'y': {
                sb.deleteCharAt(sb.length() - 1).append("ies");
                break;
            }
            case 's': {
                sb.append("es");
                break;
            }
            default: {
                sb.append('s');
            }
        }
        return sb.toString();
    }

    private static Type[] getGenericParameterTypes(Class<?> clazz) {
        Type[] types;
        for (Type type : types = clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
    }

    private static Class getClassOfTypeArgument(Class aClass, int index) {
        Type[] genericArguments = ProxyIvisServiceFactoryBuilder.getGenericParameterTypes(aClass);
        Type argument = genericArguments[index];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        throw new IllegalStateException("Type argument(" + index + ") is not a Class instance");
    }

    public Set<AbstractOAuth2Service> getServiceInstanceSet() {
        return this.serviceInstanceSet;
    }

    public ProxyIvisServiceFactoryBuilder setServiceInstanceSet(Set<AbstractOAuth2Service> serviceInstanceSet) {
        this.serviceInstanceSet = serviceInstanceSet;
        return this;
    }

    public IvisServiceFactory build() {
        this.checkMandatoryFields();
        ProxyIvisServiceFactory factory = new ProxyIvisServiceFactory(this.apiUrl, this.clientContext, this.client);
        if (StringUtils.isNotEmpty((CharSequence)this.entityPackage)) {
            Set<Class<AbstractIdEntity>> entityClasses = this.getClasses(this.entityPackage, AbstractIdEntity.class);
            this.entityClassSet.addAll(entityClasses);
            factory.setEntityClassSet(this.entityClassSet);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.servicePackage)) {
            this.addServiceInstances(factory, this.servicePackage);
            factory.addServices(this.serviceInstanceSet);
        }
        for (Class<AbstractOAuth2Service> serviceClass : this.serviceClassSet) {
            this.addServiceInstance(factory, serviceClass);
        }
        factory.fillServiceMap();
        return factory;
    }

    public static void main(String[] args) {
        ProxyIvisServiceFactoryBuilder builder = new ProxyIvisServiceFactoryBuilder();
    }
}

