/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.services.GenericService;
import com.imcode.services.NamedService;
import com.imcode.services.PersonalizedService;
import imcode.services.IvisServiceFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public abstract class AbstractOAuth2Service<T, ID>
implements GenericService<T, ID>,
NamedService<T>,
PersonalizedService<T> {
    private static final HashMap<String, Object> EMPTY_PARAMS = new HashMap();
    private String mainServiceAddres;
    private RestServiceRequest findAllRequest;
    private RestServiceRequest findRequest;
    private RestServiceRequest createRequest;
    private RestServiceRequest updateRequest;
    private RestServiceRequest existsRequest;
    private RestServiceRequest deleteRequest;
    private IvisServiceFactory factory;
    private Class<T> entityClass;
    private Class<ID> entityIdClass;

    public AbstractOAuth2Service() {
    }

    public AbstractOAuth2Service(IvisServiceFactory factory) {
        this(factory, "", null, null);
    }

    public AbstractOAuth2Service(IvisServiceFactory factory, String mainServiceAddres) {
        this(factory, mainServiceAddres, null, null);
    }

    public AbstractOAuth2Service(IvisServiceFactory factory, String mainServiceAddres, Class<T> entityClass, Class<ID> entityIdClass) {
        this.factory = factory;
        this.mainServiceAddres = mainServiceAddres;
        this.entityClass = entityClass;
        this.entityIdClass = entityIdClass;
        this.fillServiseAdderess(mainServiceAddres);
    }

    private OAuth2ProtectedResourceDetails getClient() {
        return this.factory.getClient();
    }

    private OAuth2ClientContext getClientContext() {
        return this.factory.getClientContext();
    }

    protected OAuth2RestTemplate getRestTemplate() {
        return new OAuth2RestTemplate(this.getClient(), this.getClientContext());
    }

    public T save(T entity) {
        Object result = null;
        AbstractIdEntity idEntity = (AbstractIdEntity)entity;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiceRequest request = null;
        Object[] uriVariables = null;
        if (idEntity.getId() == null) {
            request = this.getCreateRequest();
            String uri = request.getAddress();
            HttpMethod method = request.getMethod();
            result = restTemplate.postForObject(uri, entity, this.getEntityClass(), new Object[0]);
        } else {
            request = this.getUpdateRequest();
            uriVariables = new Object[]{idEntity.getId()};
            String uri = request.getAddress();
            HttpMethod method = request.getMethod();
            restTemplate.put(uri, entity, uriVariables);
        }
        return (T)result;
    }

    public Iterable<T> save(Iterable<T> entities) {
        RestServiceRequest request = this.getCreateRequest();
        LinkedList result = new LinkedList();
        String uri = request.getAddress() + "/bulk";
        HttpMethod method = request.getMethod();
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        ParameterizedTypeReference<List<T>> typeReference = this.getListTypeReference();
        RequestObject<T> requestObject = new RequestObject<T>(entities);
        RequestEntity httpEntity = null;
        try {
            httpEntity = new RequestEntity(entities, HttpMethod.POST, new URI(uri));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, (HttpEntity)httpEntity, typeReference, new Object[0]);
        if (responseEntity.getBody() != null) {
            return (Iterable)responseEntity.getBody();
        }
        return result;
    }

    public T find(ID id) {
        return this.obtainEntity(this.getFindRequest(), AbstractOAuth2Service.parameterMap("id", id));
    }

    public boolean exist(ID id) {
        boolean result = false;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiceRequest request = this.getExistsRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        Object[] uriVariables = new Object[]{id};
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, Boolean.class, uriVariables);
        if (responseEntity.getBody() != null) {
            result = (Boolean)responseEntity.getBody();
        }
        return result;
    }

    public T findFirstByName(String name) {
        return this.obtainEntity(this.getFindAllRequest(), AbstractOAuth2Service.parameterMap("name,first", name, true));
    }

    protected T obtainEntity(RestServiceRequest request, Map<String, ?> params) {
        Object result = null;
        String uri = AbstractOAuth2Service.buildUrlString(request, params);
        HttpMethod method = request.getMethod();
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, this.getEntityClass(), new Object[0]);
        if (responseEntity.getBody() != null) {
            result = responseEntity.getBody();
        }
        return (T)result;
    }

    protected List<T> obtainEntityList(RestServiceRequest request, Map<String, ?> params) {
        ParameterizedTypeReference<List<T>> typeReference;
        LinkedList result = new LinkedList();
        String uri = AbstractOAuth2Service.buildUrlString(request, params);
        HttpMethod method = request.getMethod();
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, typeReference = this.getListTypeReference(), new Object[0]);
        if (responseEntity.getBody() != null) {
            return (List)responseEntity.getBody();
        }
        return result;
    }

    public List<T> findByName(String name) {
        return this.obtainEntityList(this.getFindAllRequest(), AbstractOAuth2Service.parameterMap("name", name));
    }

    public T findFirstByPersonalId(String personalId) {
        return this.obtainEntity(this.getFindAllRequest(), AbstractOAuth2Service.parameterMap("personalId,first", personalId, true));
    }

    public List<T> findByPersonalId(String personalId) {
        return this.obtainEntityList(this.getFindAllRequest(), AbstractOAuth2Service.parameterMap("personalId", personalId));
    }

    public void delete(ID id) {
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiceRequest request = this.getDeleteRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        Object[] uriVariables = new Object[]{id};
        restTemplate.exchange(uri, method, null, Void.TYPE, uriVariables);
    }

    public List<T> findAll() {
        return this.obtainEntityList(this.getFindAllRequest(), EMPTY_PARAMS);
    }

    private Class<T> getGeneticType(String variableName) {
        Map params = GenericTypeResolver.getTypeVariableMap(this.getClass());
        for (Map.Entry entry : params.entrySet()) {
            if (!((TypeVariable)entry.getKey()).getName().equals(variableName)) continue;
            return (Class)entry.getValue();
        }
        return null;
    }

    protected ParameterizedTypeReference<List<T>> getListTypeReference() {
        final Class<T> entityClass = this.getEntityClass();
        ParameterizedTypeReference typeReference = new ParameterizedTypeReference<List<T>>(){

            public Type getType() {
                return ParameterizedTypeImpl.make(List.class, new Class[]{entityClass}, null);
            }
        };
        return typeReference;
    }

    protected Class<T> getEntityClass() {
        if (this.entityClass != null) {
            return this.entityClass;
        }
        Type[] genericArguments = this.getGenericParameterTypes();
        return (Class)genericArguments[0];
    }

    protected Class getIdClass() {
        if (this.entityIdClass != null) {
            return this.entityIdClass;
        }
        Type[] genericArguments = this.getGenericParameterTypes();
        return (Class)genericArguments[1];
    }

    protected Type[] getGenericParameterTypes() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return parameterizedType.getActualTypeArguments();
    }

    public String getMainServiceAddres() {
        return this.mainServiceAddres;
    }

    public void setMainServiceAddres(String mainServiceAddres) {
        this.mainServiceAddres = mainServiceAddres;
    }

    public RestServiceRequest getFindAllRequest() {
        return this.findAllRequest;
    }

    public void setFindAllRequest(RestServiceRequest findAllRequest) {
        this.findAllRequest = findAllRequest;
    }

    public RestServiceRequest getFindRequest() {
        return this.findRequest;
    }

    public void setFindRequest(RestServiceRequest findRequest) {
        this.findRequest = findRequest;
    }

    public RestServiceRequest getCreateRequest() {
        return this.createRequest;
    }

    public void setCreateRequest(RestServiceRequest createRequest) {
        this.createRequest = createRequest;
    }

    public RestServiceRequest getUpdateRequest() {
        return this.updateRequest;
    }

    public void setUpdateRequest(RestServiceRequest updateRequest) {
        this.updateRequest = updateRequest;
    }

    public RestServiceRequest getExistsRequest() {
        return this.existsRequest;
    }

    public void setExistsRequest(RestServiceRequest existsRequest) {
        this.existsRequest = existsRequest;
    }

    public RestServiceRequest getDeleteRequest() {
        return this.deleteRequest;
    }

    public void setDeleteRequest(RestServiceRequest deleteRequest) {
        this.deleteRequest = deleteRequest;
    }

    public void fillServiseAdderess(String mainServiceAddres) {
        this.mainServiceAddres = mainServiceAddres;
        this.createRequest = new RestServiceRequest(mainServiceAddres, HttpMethod.POST);
        this.findAllRequest = new RestServiceRequest(mainServiceAddres, HttpMethod.GET);
        this.findRequest = new RestServiceRequest(mainServiceAddres + "/{id}", HttpMethod.GET);
        this.existsRequest = new RestServiceRequest(this.findRequest.address, HttpMethod.GET);
        this.updateRequest = new RestServiceRequest(this.findRequest.address, HttpMethod.PUT);
        this.deleteRequest = new RestServiceRequest(this.findRequest.address, HttpMethod.DELETE);
    }

    public static void main(String[] args) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        RestServiceRequest request = new RestServiceRequest("http://www.i.ua", HttpMethod.GET);
        params.put("id", 9);
        params.put("mla", 89);
        System.out.println(AbstractOAuth2Service.buildUrlString(request, params));
        params = null;
        System.out.println(AbstractOAuth2Service.buildUrlString(request, params));
        params = new HashMap();
        System.out.println(AbstractOAuth2Service.buildUrlString(request, params));
    }

    private static String buildUrlString(RestServiceRequest request, Map<String, ?> params) {
        String paramString = "";
        if (params != null) {
            List nameValuePairs = params.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), Objects.toString(entry.getValue()))).collect(Collectors.toList());
            paramString = URLEncodedUtils.format(nameValuePairs, (Charset)Charset.forName("UTF-8"));
        }
        return request.getAddress() + (StringUtils.isEmpty((CharSequence)paramString) ? paramString : "?" + paramString);
    }

    private static Map<String, Object> parameterMap(String keyString, Object ... values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] keys = keyString.split("\\W+");
        for (int i = 0; i < keys.length; ++i) {
            Object o = i < values.length ? values[i] : null;
            map.put(keys[i], o);
        }
        return map;
    }

    public static class RequestObject<T> {
        private List<T> entities;

        public RequestObject() {
        }

        public RequestObject(Iterable<T> entities) {
            List list = new ArrayList();
            if (entities instanceof List) {
                list = (List)entities;
            } else {
                entities.forEach(list::add);
            }
            this.entities = list;
        }

        public List<T> getEntities() {
            return this.entities;
        }

        public void setEntities(List<T> entities) {
            this.entities = entities;
        }
    }

    public static class RestServiceRequest {
        private final String address;
        private final HttpMethod method;

        public RestServiceRequest(String address, HttpMethod method) {
            this.address = address;
            this.method = method;
        }

        public String getAddress() {
            return this.address;
        }

        public HttpMethod getMethod() {
            return this.method;
        }
    }

    public static class RestServiceRequestBuilder {
        private static final HttpMethod DEFAULT_METHOD = HttpMethod.GET;
        private StringBuilder address;
        private HttpMethod method = DEFAULT_METHOD;

        public RestServiceRequestBuilder(RestServiceRequest prototype) {
            this.method = prototype.method;
            this.address = new StringBuilder(prototype.address);
        }

        public RestServiceRequestBuilder setAddress(String address) {
            this.address = new StringBuilder(address);
            return this;
        }

        public RestServiceRequestBuilder appendAddress(String address) {
            this.address.append(address);
            return this;
        }

        public RestServiceRequestBuilder setMethod(HttpMethod method) {
            this.method = method;
            return this;
        }

        public RestServiceRequest build() {
            return new RestServiceRequest(this.address.toString(), HttpMethod.GET);
        }
    }
}

