/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.entities.School;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.enums.ServiceTypeEnum;
import com.imcode.entities.superclasses.AbstractIdEntity;
import com.imcode.services.ApplicationService;
import com.imcode.services.GenericService;
import com.imcode.services.SchoolClassService;
import com.imcode.services.SchoolService;
import imcode.services.GenericServiceProxy;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.AbstractOAuth2Service;
import imcode.services.restful.ProxyIvisServiceFactoryBuilder;
import imcode.services.restful.ServiceInfo;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.Entity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.Assert;

public class ProxyIvisServiceFactory
implements IvisServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProxyIvisServiceFactory.class);
    public static final String DEFAULT_ENTITY_PACKEDGE = "com.imcode.entities";
    public static final String DEFAULT_SERVICE_PACKEDGE = "imcode.services.restful";
    public static final Class<? extends GenericService> DEFAULT_SERVICE_IMPLEMENTATION = OAuth2Service.class;
    public Class<? extends GenericService> abstractOAuth2ServiceClass = DEFAULT_SERVICE_IMPLEMENTATION;
    private final String apiUrl;
    private final OAuth2ClientContext clientContext;
    private final OAuth2ProtectedResourceDetails client;
    private Set<Class<? extends AbstractIdEntity>> entityClassSet = new HashSet<Class<? extends AbstractIdEntity>>();
    private Set<AbstractOAuth2Service> serviceSet = new HashSet<AbstractOAuth2Service>();
    private Map<Class<? extends GenericService>, ServiceInfo> serviceMap = new HashMap<Class<? extends GenericService>, ServiceInfo>();
    private String entityPackage;
    private String servicePackage;

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client) {
        this(apiUrl, clientContext, client, DEFAULT_ENTITY_PACKEDGE);
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, String entityPackedge) {
        this(apiUrl, clientContext, client, entityPackedge, DEFAULT_SERVICE_PACKEDGE);
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, List<Class<? extends AbstractIdEntity>> entityClassSet) {
        this(apiUrl, clientContext, client, entityClassSet, Collections.emptyList());
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, List<Class<? extends AbstractIdEntity>> entityClassSet, List<AbstractOAuth2Service> serviceSet) {
        this.apiUrl = apiUrl;
        this.clientContext = clientContext;
        this.client = client;
        this.entityClassSet = new HashSet<Class<? extends AbstractIdEntity>>(entityClassSet);
        this.serviceSet = new HashSet<AbstractOAuth2Service>(serviceSet);
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, String entityPackage, String servicePackage) {
        this(apiUrl, clientContext, client, Collections.emptyList(), Collections.emptyList());
        this.entityPackage = entityPackage;
        this.servicePackage = servicePackage;
    }

    @PostConstruct
    public void initialize() {
        if ((this.entityClassSet == null || this.entityClassSet.isEmpty()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.entityPackage})) {
            this.entityClassSet = new HashSet<Class<? extends AbstractIdEntity>>(this.loadEntities(this.entityPackage));
        }
        if ((this.serviceSet == null || this.serviceSet.isEmpty()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.servicePackage})) {
            this.serviceSet = new HashSet<AbstractOAuth2Service>(this.loadServices(this.servicePackage));
        }
        this.fillServiceMap();
    }

    public Set<Class<? extends AbstractIdEntity>> getEntityClassSet() {
        return this.entityClassSet;
    }

    public void setEntityClassSet(Set<Class<? extends AbstractIdEntity>> entityClassSet) {
        this.entityClassSet = entityClassSet;
    }

    protected void fillServiceMap() {
        this.serviceMap = new HashMap<Class<? extends GenericService>, ServiceInfo>();
        for (Class<? extends AbstractIdEntity> entityClass : this.entityClassSet) {
            try {
                GenericService implementation = this.getServiceImplementation(entityClass);
                Class<GenericService> serviceInterface = this.getServiceInterface(entityClass);
                this.serviceMap.put(serviceInterface, new ServiceInfo(entityClass, ProxyIvisServiceFactory.getEntityIdClass(entityClass), implementation));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
    }

    protected Class<GenericService> getServiceInterface(Class entityClass) {
        Class<GenericService> serviceClass = null;
        try {
            serviceClass = Class.forName("com.imcode.services." + entityClass.getSimpleName() + "Service");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Service interface for entity " + entityClass + " not found");
        }
        return serviceClass;
    }

    protected <T extends AbstractIdEntity<ID>, ID extends Serializable> GenericService<T, ID> getServiceImplementation(Class<T> entityClass) {
        for (GenericService genericService : this.serviceSet) {
            Class<?> serviceClass = genericService.getClass();
            Class serviceEntityClass = ProxyIvisServiceFactory.getClassOfTypeArgument(serviceClass, 0);
            if (!serviceEntityClass.equals(entityClass)) continue;
            logger.info("find favorite implementation " + serviceClass + " for entity " + entityClass);
            return genericService;
        }
        Class<ID> entityIdClass = ProxyIvisServiceFactory.getEntityIdClass(entityClass);
        return this.getAbstractOAuth2ServiceImplementation(entityClass, entityIdClass);
    }

    private static ClassPathScanningCandidateComponentProvider getEntityScaner() {
        ClassPathScanningCandidateComponentProvider componentScaner = new ClassPathScanningCandidateComponentProvider(false);
        componentScaner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractIdEntity.class));
        return componentScaner;
    }

    private static ClassPathScanningCandidateComponentProvider getServiceScaner() {
        ClassPathScanningCandidateComponentProvider componentScaner = new ClassPathScanningCandidateComponentProvider(false);
        componentScaner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractOAuth2Service.class));
        return componentScaner;
    }

    public List<Class<? extends AbstractIdEntity>> loadEntities(String packedge) {
        ArrayList<Class<? extends AbstractIdEntity>> entityClassList = new ArrayList<Class<? extends AbstractIdEntity>>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{packedge})) {
            ClassPathScanningCandidateComponentProvider entityScaner = ProxyIvisServiceFactory.getEntityScaner();
            Set entitySet = entityScaner.findCandidateComponents(packedge);
            for (BeanDefinition beanDefinition : entitySet) {
                String className = "";
                try {
                    className = beanDefinition.getBeanClassName();
                    entityClassList.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load class \"" + className + "\"", e);
                }
            }
        }
        return entityClassList;
    }

    public List<AbstractOAuth2Service> loadServices(String packedge) {
        ArrayList<AbstractOAuth2Service> serviceList = new ArrayList<AbstractOAuth2Service>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{packedge})) {
            ClassPathScanningCandidateComponentProvider serviceScaner = ProxyIvisServiceFactory.getServiceScaner();
            Set serviceSet = serviceScaner.findCandidateComponents(packedge);
            for (BeanDefinition beanDefinition : serviceSet) {
                String className = "";
                try {
                    className = beanDefinition.getBeanClassName();
                    Class<?> serviceClass = Class.forName(className);
                    Class entityClass = ProxyIvisServiceFactory.getClassOfTypeArgument(serviceClass, 0);
                    Constructor<?> constructor = serviceClass.getConstructor(IvisServiceFactory.class, String.class);
                    AbstractOAuth2Service instance = (AbstractOAuth2Service)constructor.newInstance(this, this.getDefaultServiceAlias(entityClass));
                    serviceList.add(instance);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Unable to load class \"" + className + "\"");
                }
                catch (InstantiationException e) {
                    logger.error("Unable to create instance of class \"" + className + "\"");
                }
                catch (NoSuchMethodException e) {
                    logger.error("Constructor not fuond \"" + className + "\"");
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return serviceList;
    }

    protected void checkEntityClassList(List<Class> entityClassList) {
        for (Class entityClass : entityClassList) {
            Assert.notNull((Object)entityClass.getAnnotation(Entity.class), (String)(entityClass.getName() + " is not an entity class"));
        }
    }

    @Override
    public <S extends GenericService<T, ID>, T, ID> S getService(Class<S> serviceClass) {
        ServiceInfo serviceInfo = this.serviceMap.get(serviceClass);
        if (serviceInfo != null) {
            return (S)serviceInfo.getService();
        }
        throw new RuntimeException("No such service!");
    }

    @Override
    public <S extends GenericService<T, ID>, T, ID> S getServiceFor(Class<T> entityClass) {
        Class<GenericService> serviceInterface = this.getServiceInterface(entityClass);
        return (S)this.getService(serviceInterface);
    }

    private <T, ID> GenericService<T, ID> getAbstractOAuth2ServiceImplementation(Class entityClass, Class idClass) {
        try {
            Constructor<? extends GenericService> constructor = this.abstractOAuth2ServiceClass.getConstructor(IvisServiceFactory.class, String.class, Class.class, Class.class);
            OAuth2Service instance = (OAuth2Service)constructor.newInstance(this, this.getDefaultServiceAlias(entityClass), entityClass, idClass);
            GenericService proxy = GenericServiceProxy.newInstance(instance, this.getServiceInterface(entityClass));
            return proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instanse of abstract class");
        }
    }

    private static Type[] getGenericParameterTypes(Class<?> clazz) {
        Type[] types;
        for (Type type : types = clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public OAuth2ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public boolean hasServiceFor(Class entityClass) {
        for (ServiceInfo serviceInfo : this.serviceMap.values()) {
            if (!entityClass.equals(serviceInfo.entityClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasService(Class<? extends GenericService> service) {
        return this.serviceMap.get(service) != null;
    }

    @Override
    public ServiceInfo getServiceInfo(Class<? extends GenericService> serviceClass) {
        return this.serviceMap.get(serviceClass);
    }

    @Override
    public ServiceInfo getServiceInfoFor(Class entity) {
        for (ServiceInfo serviceInfo : this.serviceMap.values()) {
            if (!entity.equals(serviceInfo.entityClass)) continue;
            return serviceInfo;
        }
        return null;
    }

    @Override
    public OAuth2ProtectedResourceDetails getClient() {
        return this.client;
    }

    private String getDefaultServiceAlias(Class<? extends AbstractIdEntity> serviseClass) {
        StringBuilder sb = new StringBuilder(this.apiUrl).append('/').append(serviseClass.getSimpleName().toLowerCase());
        char lastLater = sb.charAt(sb.length() - 1);
        switch (lastLater) {
            case 'y': {
                sb.deleteCharAt(sb.length() - 1).append("ies");
                break;
            }
            case 's': {
                sb.append("es");
                break;
            }
            default: {
                sb.append('s');
            }
        }
        return sb.toString();
    }

    private static Class getClassOfTypeArgument(Class aClass, int index) {
        Type[] genericArguments = ProxyIvisServiceFactory.getGenericParameterTypes(aClass);
        Type argument = genericArguments[index];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        throw new IllegalStateException("Type argument(" + index + ") is not a Class instance");
    }

    public static <ID extends Serializable> Class<ID> getEntityIdClass(Class<? extends AbstractIdEntity> entityClass) {
        Type parameter = ((ParameterizedType)entityClass.getGenericSuperclass()).getActualTypeArguments()[0];
        return (Class)parameter;
    }

    public List<Class<? extends AbstractIdEntity>> getEntityClassList() {
        return new ArrayList<Class<? extends AbstractIdEntity>>(this.entityClassSet);
    }

    public void setEntityClassList(Set<Class<? extends AbstractIdEntity>> entityClassList) {
        this.entityClassSet = entityClassList;
    }

    @Deprecated
    public Set<AbstractOAuth2Service> getServiceSet() {
        return this.serviceSet;
    }

    @Deprecated
    public void setServiceSet(Set<AbstractOAuth2Service> serviceSet) {
        this.serviceSet = serviceSet;
    }

    void addService(AbstractOAuth2Service service) {
        this.serviceSet.add(service);
    }

    void addServices(Collection<AbstractOAuth2Service> services) {
        this.serviceSet.addAll(services);
    }

    public static void main(String[] args) {
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setId("ivis");
        resource.setClientId("ff11397c-3e3b-4398-80a9-feba203f1928");
        resource.setGrantType("password");
        resource.setClientSecret("secret");
        resource.setAccessTokenUri("http://localhost:8080/ivis/oauth/token");
        resource.setScope(Arrays.asList("read"));
        resource.setUsername("admin");
        resource.setPassword("pass");
        int expired = 599;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, expired);
        Date ecxpirationDate = calendar.getTime();
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("read");
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken("acf95060-9303-4fbd-992a-c54157f16eab");
        accessToken.setTokenType("bearer");
        accessToken.setScope(scopes);
        accessToken.setRefreshToken((OAuth2RefreshToken)new DefaultExpiringOAuth2RefreshToken("fb99a06d-027d-4550-b969-f9bda5103e6d", ecxpirationDate));
        accessToken.setExpiration(ecxpirationDate);
        DefaultOAuth2ClientContext clientContext = new DefaultOAuth2ClientContext();
        clientContext.setAccessToken((OAuth2AccessToken)accessToken);
        try {
            IvisServiceFactory serviceFactory = new ProxyIvisServiceFactoryBuilder().setApiUrl("http://localhost:8080/ivis/api/v1/json").setClientContext((OAuth2ClientContext)clientContext).setClient((OAuth2ProtectedResourceDetails)resource).build();
            ApplicationService service = serviceFactory.getService(ApplicationService.class);
            SchoolService schoolService = serviceFactory.getService(SchoolService.class);
            SchoolClassService schoolClassService = serviceFactory.getService(SchoolClassService.class);
            schoolClassService.findAll();
            School school = new School();
            school.setName("School #1");
            school.setSchoolId("15uy");
            school.setServices(new ServiceTypeEnum[]{ServiceTypeEnum.AFTER_SCHOOL_CENTER, ServiceTypeEnum.ELEMENTARY_SCHOOL});
            school = (School)schoolService.save((Object)school);
            SchoolClass schoolClass = new SchoolClass("School class #1", school, new Date(), new Date());
            schoolClass = (SchoolClass)schoolClassService.save((Object)schoolClass);
            school = (School)schoolService.find((Object)school.getId());
            System.out.println(school);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class OAuth2Service
    extends AbstractOAuth2Service {
        public OAuth2Service(IvisServiceFactory factory, String mainServiceAddres, Class entityClass, Class entityIdClass) {
            super(factory, mainServiceAddres, entityClass, entityIdClass);
        }
    }
}

