/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.entities.AbstractIdEntity;
import com.imcode.entities.Pupil;
import com.imcode.services.GenericService;
import com.imcode.services.PupilService;
import imcode.services.GenericServiceProxy;
import imcode.services.IvisServiceFactory;
import imcode.services.restful.AbstractOAuth2Service;
import imcode.services.restful.ServiceInfo;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.Entity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.Assert;

public class ProxyIvisServiceFactory
implements IvisServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_ENTITY_PACKEDGE = "com.imcode.entities";
    public static final Class<? extends GenericService> DEFAULT_SERVICE_IMPLEMENTATION = OAuth2Service.class;
    public Class<? extends GenericService> abstractOAuth2ServiceClass = DEFAULT_SERVICE_IMPLEMENTATION;
    private final String apiUrl;
    private final OAuth2ClientContext clientContext;
    private final OAuth2ProtectedResourceDetails client;
    private List<Class<? extends AbstractIdEntity>> entityClassList = new LinkedList<Class<? extends AbstractIdEntity>>();
    private List<AbstractOAuth2Service> favoriteServiceList = new LinkedList<AbstractOAuth2Service>();
    private Map<Class<? extends GenericService>, ServiceInfo> serviceMap = new HashMap<Class<? extends GenericService>, ServiceInfo>();
    private String entityPackage;
    private String servicePackage;

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client) {
        this(apiUrl, clientContext, client, DEFAULT_ENTITY_PACKEDGE);
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, String entityPackedge) {
        this(apiUrl, clientContext, client, entityPackedge, "");
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, List<Class<? extends AbstractIdEntity>> entityClassList) {
        this(apiUrl, clientContext, client, entityClassList, Collections.EMPTY_LIST);
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, List<Class<? extends AbstractIdEntity>> entityClassList, List<AbstractOAuth2Service> favoriteServiceList) {
        this.apiUrl = apiUrl;
        this.clientContext = clientContext;
        this.client = client;
        this.entityClassList = Collections.unmodifiableList(entityClassList);
        this.favoriteServiceList = Collections.unmodifiableList(favoriteServiceList);
        this.fillServiceMap();
    }

    public ProxyIvisServiceFactory(String apiUrl, OAuth2ClientContext clientContext, OAuth2ProtectedResourceDetails client, String entityPackage, String servicePackage) {
        this.apiUrl = apiUrl;
        this.clientContext = clientContext;
        this.client = client;
        this.entityPackage = entityPackage;
        this.servicePackage = servicePackage;
    }

    @PostConstruct
    public void initialize() {
        if (this.entityClassList.isEmpty() && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.entityPackage})) {
            this.entityClassList = this.loadEntities(this.entityPackage);
        }
        if (this.favoriteServiceList.isEmpty() && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.servicePackage})) {
            this.favoriteServiceList = this.loadServices(this.servicePackage);
        }
        this.fillServiceMap();
    }

    protected void fillServiceMap() {
        this.serviceMap = new HashMap<Class<? extends GenericService>, ServiceInfo>();
        for (Class<? extends AbstractIdEntity> entityClass : this.entityClassList) {
            try {
                GenericService implementation = this.getServiceImplementation(entityClass);
                Class<GenericService> serviceInterface = this.getServiceInterface(entityClass);
                this.serviceMap.put(serviceInterface, new ServiceInfo(entityClass, ProxyIvisServiceFactory.getEntityIdClass(entityClass), implementation));
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
    }

    protected Class<GenericService> getServiceInterface(Class entityClass) {
        Class<GenericService> serviceClass = null;
        try {
            serviceClass = Class.forName("com.imcode.services." + entityClass.getSimpleName() + "Service");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Service interface for entity " + entityClass + " not found");
        }
        return serviceClass;
    }

    protected <T extends AbstractIdEntity<ID>, ID extends Serializable> GenericService<T, ID> getServiceImplementation(Class<T> entityClass) {
        for (GenericService genericService : this.favoriteServiceList) {
            Class<?> serviceClass = genericService.getClass();
            Class serviceEntityClass = ProxyIvisServiceFactory.getClassOfTypeArgument(serviceClass, 0);
            if (!serviceEntityClass.equals(entityClass)) continue;
            this.logger.info("find favorite implementation " + serviceClass + " for entity " + entityClass);
            return genericService;
        }
        Class<ID> entityIdClass = ProxyIvisServiceFactory.getEntityIdClass(entityClass);
        return this.getAbstractOAuth2ServiceImplementation(entityClass, entityIdClass);
    }

    private static ClassPathScanningCandidateComponentProvider getEntityScaner() {
        ClassPathScanningCandidateComponentProvider componentScaner = new ClassPathScanningCandidateComponentProvider(false);
        componentScaner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractIdEntity.class));
        return componentScaner;
    }

    private static ClassPathScanningCandidateComponentProvider getServiceScaner() {
        ClassPathScanningCandidateComponentProvider componentScaner = new ClassPathScanningCandidateComponentProvider(false);
        componentScaner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractOAuth2Service.class));
        return componentScaner;
    }

    public List<Class<? extends AbstractIdEntity>> loadEntities(String packedge) {
        ClassPathScanningCandidateComponentProvider entityScaner = ProxyIvisServiceFactory.getEntityScaner();
        Set entitySet = entityScaner.findCandidateComponents(packedge);
        ArrayList<Class<? extends AbstractIdEntity>> entityClassList = new ArrayList<Class<? extends AbstractIdEntity>>(entitySet.size());
        for (BeanDefinition beanDefinition : entitySet) {
            String className = "";
            try {
                className = beanDefinition.getBeanClassName();
                entityClassList.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load class \"" + className + "\"", e);
            }
        }
        return entityClassList;
    }

    public List<AbstractOAuth2Service> loadServices(String packedge) {
        ClassPathScanningCandidateComponentProvider serviceScaner = ProxyIvisServiceFactory.getServiceScaner();
        Set serviceSet = serviceScaner.findCandidateComponents(packedge);
        ArrayList<AbstractOAuth2Service> serviceList = new ArrayList<AbstractOAuth2Service>(serviceSet.size());
        for (BeanDefinition beanDefinition : serviceSet) {
            String className = "";
            try {
                className = beanDefinition.getBeanClassName();
                Class<?> serviceClass = Class.forName(className);
                Class entityClass = ProxyIvisServiceFactory.getClassOfTypeArgument(serviceClass, 0);
                Constructor<?> constructor = serviceClass.getConstructor(IvisServiceFactory.class, String.class);
                AbstractOAuth2Service instance = (AbstractOAuth2Service)constructor.newInstance(this, this.getDefaultServiceAlias(entityClass));
                serviceList.add(instance);
            }
            catch (ClassNotFoundException e) {
                this.logger.error("Unable to load class \"" + className + "\"");
            }
            catch (InstantiationException e) {
                this.logger.error("Unable to create instance of class \"" + className + "\"");
            }
            catch (NoSuchMethodException e) {
                this.logger.error("Constructor not fuond \"" + className + "\"");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return serviceList;
    }

    protected void checkEntityClassList(List<Class> entityClassList) {
        for (Class entityClass : entityClassList) {
            Assert.notNull((Object)entityClass.getAnnotation(Entity.class), (String)(entityClass.getName() + " is not an entity class"));
        }
    }

    @Override
    public <S extends GenericService<T, ID>, T, ID> S getService(Class<S> serviceClass) {
        ServiceInfo serviceInfo = this.serviceMap.get(serviceClass);
        if (serviceInfo != null) {
            return (S)serviceInfo.getService();
        }
        throw new RuntimeException("No such service!");
    }

    private <T, ID> GenericService<T, ID> getAbstractOAuth2ServiceImplementation(Class entityClass, Class idClass) {
        try {
            Constructor<? extends GenericService> constructor = this.abstractOAuth2ServiceClass.getConstructor(IvisServiceFactory.class, String.class, Class.class, Class.class);
            OAuth2Service instance = (OAuth2Service)constructor.newInstance(this, this.getDefaultServiceAlias(entityClass), entityClass, idClass);
            GenericService proxy = GenericServiceProxy.newInstance(instance, this.getServiceInterface(entityClass));
            return proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instanse of abstract class");
        }
    }

    private static Type[] getGenericParameterTypes(Class<?> clazz) {
        Type[] types;
        for (Type type : types = clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public OAuth2ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public boolean hasServiceFor(Class entityClass) {
        for (ServiceInfo serviceInfo : this.serviceMap.values()) {
            if (!entityClass.equals(serviceInfo.entityClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasService(Class<? extends GenericService> service) {
        return this.serviceMap.get(service) != null;
    }

    @Override
    public ServiceInfo getServiceInfo(Class<? extends GenericService> serviceClass) {
        return this.serviceMap.get(serviceClass);
    }

    @Override
    public ServiceInfo getServiceInfoFor(Class entity) {
        for (ServiceInfo serviceInfo : this.serviceMap.values()) {
            if (!entity.equals(serviceInfo.entityClass)) continue;
            return serviceInfo;
        }
        return null;
    }

    @Override
    public OAuth2ProtectedResourceDetails getClient() {
        return this.client;
    }

    private String getDefaultServiceAlias(Class<? extends AbstractIdEntity> serviseClass) {
        StringBuilder sb = new StringBuilder(this.apiUrl).append('/').append(serviseClass.getSimpleName().toLowerCase());
        char lastLater = sb.charAt(sb.length() - 1);
        switch (lastLater) {
            case 'y': {
                sb.deleteCharAt(sb.length() - 1).append("ies");
                break;
            }
            case 's': {
                sb.append("es");
                break;
            }
            default: {
                sb.append('s');
            }
        }
        return sb.toString();
    }

    private static Class getClassOfTypeArgument(Class aClass, int index) {
        Type[] genericArguments = ProxyIvisServiceFactory.getGenericParameterTypes(aClass);
        Type argument = genericArguments[index];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        throw new IllegalStateException("Type argument(" + index + ") is not a Class instance");
    }

    public static <ID extends Serializable> Class<ID> getEntityIdClass(Class<? extends AbstractIdEntity> entityClass) {
        Type parameter = ((ParameterizedType)entityClass.getGenericSuperclass()).getActualTypeArguments()[0];
        return (Class)parameter;
    }

    public static void main(String[] args) {
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setId("ivis");
        resource.setClientId("b4251265-409d-43b3-928d-a290228a2b59");
        resource.setGrantType("password");
        resource.setClientSecret("secret");
        resource.setAccessTokenUri("http://localhost:8080/ivis/oauth/token");
        resource.setScope(Arrays.asList("read"));
        resource.setUsername("admin");
        resource.setPassword("pass");
        int expired = 599;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, expired);
        Date ecxpirationDate = calendar.getTime();
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("read");
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken("acf95060-9303-4fbd-992a-c54157f16eab");
        accessToken.setTokenType("bearer");
        accessToken.setScope(scopes);
        accessToken.setRefreshToken((OAuth2RefreshToken)new DefaultExpiringOAuth2RefreshToken("fb99a06d-027d-4550-b969-f9bda5103e6d", ecxpirationDate));
        accessToken.setExpiration(ecxpirationDate);
        DefaultOAuth2ClientContext clientContext = new DefaultOAuth2ClientContext();
        clientContext.setAccessToken((OAuth2AccessToken)accessToken);
        try {
            ProxyIvisServiceFactory serviceFactory = new ProxyIvisServiceFactory("http://localhost:8080/ivis/api/v1/json", (OAuth2ClientContext)clientContext, (OAuth2ProtectedResourceDetails)resource, DEFAULT_ENTITY_PACKEDGE, "imcode.services.restful");
            serviceFactory.initialize();
            System.out.println("sfas");
            PupilService service = serviceFactory.getService(PupilService.class);
            Pupil entity = (Pupil)service.find((Object)1);
            System.out.println(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class OAuth2Service
    extends AbstractOAuth2Service {
        public OAuth2Service(IvisServiceFactory factory, String mainServiceAddres, Class entityClass, Class entityIdClass) {
            super(factory, mainServiceAddres, entityClass, entityIdClass);
        }
    }
}

