/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.utils;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class IvisOAuth2Utils {
    public static final String CLIENT_CONTEXT_PARAMETER_NAME = "oauth2ClientContext";

    public static OAuth2ClientContext getClientContext(HttpServletRequest request) {
        return IvisOAuth2Utils.getClientContext(request.getSession());
    }

    public static OAuth2ClientContext getClientContext(HttpSession session) {
        OAuth2ClientContext clientContext = null;
        clientContext = (OAuth2ClientContext)session.getAttribute(CLIENT_CONTEXT_PARAMETER_NAME);
        return clientContext;
    }

    public static void setClientContext(HttpServletRequest request, OAuth2ClientContext clientContext) {
        IvisOAuth2Utils.setClientContext(request.getSession(), clientContext);
    }

    public static void setClientContext(HttpSession session, OAuth2ClientContext clientContext) {
        session.setAttribute(CLIENT_CONTEXT_PARAMETER_NAME, (Object)clientContext);
    }

    public static void setAccessToken(HttpSession session, OAuth2AccessToken accessToken) {
        OAuth2ClientContext clientContext = IvisOAuth2Utils.getClientContext(session);
        if (clientContext == null) {
            clientContext = new DefaultOAuth2ClientContext();
            IvisOAuth2Utils.setClientContext(session, clientContext);
        }
        clientContext.setAccessToken(accessToken);
    }

    public static void setAccessToken(HttpServletRequest request, OAuth2AccessToken accessToken) {
        IvisOAuth2Utils.setAccessToken(request.getSession(), accessToken);
    }

    public static OAuth2AccessToken getAccessToken(HttpServletRequest request) {
        return IvisOAuth2Utils.getAccessToken(request.getSession());
    }

    public static OAuth2AccessToken getAccessToken(HttpSession session) {
        OAuth2AccessToken accessToken = null;
        OAuth2ClientContext clientContext = (OAuth2ClientContext)session.getAttribute(CLIENT_CONTEXT_PARAMETER_NAME);
        if (clientContext != null) {
            accessToken = clientContext.getAccessToken();
        }
        return accessToken;
    }

    public static String getOAuth2AuthirizationUrl(AuthorizationCodeResourceDetails client, String redirectUri) throws URISyntaxException {
        return IvisOAuth2Utils.getOAuth2AuthirizationUrl(client, redirectUri, true);
    }

    public static String getOAuth2AuthirizationUrl(AuthorizationCodeResourceDetails client, String redirectUri, boolean isPopup) throws URISyntaxException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("response_type", "code"));
        parameters.add(new BasicNameValuePair("client_id", client.getClientId()));
        parameters.add(new BasicNameValuePair("redirect_uri", redirectUri));
        if (isPopup) {
            parameters.add(new BasicNameValuePair("display", "popup"));
        }
        if (client.isScoped()) {
            StringBuilder builder = new StringBuilder();
            List scope = client.getScope();
            if (scope != null) {
                Iterator scopeIt = scope.iterator();
                while (scopeIt.hasNext()) {
                    builder.append((String)scopeIt.next());
                    if (!scopeIt.hasNext()) continue;
                    builder.append(' ');
                }
            }
            parameters.add(new BasicNameValuePair("scope", builder.toString()));
        }
        URIBuilder uriBuilder = new URIBuilder(client.getUserAuthorizationUri());
        uriBuilder.addParameters(parameters);
        return uriBuilder.toString();
    }
}

