/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.services.GenericService;
import com.imcode.services.PupilService;
import com.imcode.services.SchoolClassService;
import com.imcode.services.SchoolService;
import com.imcode.services.StatementService;
import imcode.services.restful.AbstractOAuth2Service;
import imcode.services.restful.IvisFacade;
import imcode.services.restful.OAuth2PupisService;
import imcode.services.restful.OAuth2SchoolClassService;
import imcode.services.restful.OAuth2SchoolService;
import imcode.services.restful.OAuth2StatementService;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

public class IvisServiceFactory {
    private final String apiUrl;
    private OAuth2ClientContext clientContext;
    private OAuth2ProtectedResourceDetails client;
    private Map<Class<? extends GenericService>, GenericService> serviceMap;

    public IvisServiceFactory(String apiUrl, OAuth2ProtectedResourceDetails client, OAuth2ClientContext clientContext) {
        this.client = client;
        this.clientContext = clientContext;
        this.apiUrl = apiUrl;
        HashMap<Class, AbstractOAuth2Service> map = new HashMap<Class, AbstractOAuth2Service>();
        OAuth2SchoolService schoolService = new OAuth2SchoolService(this);
        schoolService.fillServiseAdderess(apiUrl + "schools");
        map.put(SchoolService.class, schoolService);
        OAuth2StatementService statementService = new OAuth2StatementService(this);
        statementService.fillServiseAdderess(apiUrl + "statements");
        map.put(StatementService.class, statementService);
        OAuth2PupisService pupisService = new OAuth2PupisService(this);
        pupisService.fillServiseAdderess(apiUrl + "pupils");
        map.put(PupilService.class, pupisService);
        OAuth2SchoolClassService schoolClassService = new OAuth2SchoolClassService(this);
        schoolClassService.fillServiseAdderess(apiUrl + "classes");
        map.put(SchoolClassService.class, schoolClassService);
        this.serviceMap = Collections.unmodifiableMap(map);
    }

    public <T extends GenericService> T getService(Class<T> serviceClass) {
        return (T)this.serviceMap.get(serviceClass);
    }

    public SchoolService getSchoolService() {
        return this.getService(SchoolService.class);
    }

    public StatementService getStatementService() {
        return this.getService(StatementService.class);
    }

    public PupilService getPupilService() {
        return this.getService(PupilService.class);
    }

    public SchoolClassService getSchoolClassService() {
        return this.getService(SchoolClassService.class);
    }

    public OAuth2ProtectedResourceDetails getClient() {
        return this.client;
    }

    public void setClient(OAuth2ProtectedResourceDetails client) {
        this.client = client;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public OAuth2ClientContext getClientContext() {
        return this.clientContext;
    }

    public void setClientContext(OAuth2ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public static void main(String[] args) {
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setId("ivis");
        resource.setClientId("b4251265-409d-43b3-928d-a290228a2b59");
        resource.setGrantType("password");
        resource.setClientSecret("secret");
        resource.setAccessTokenUri("http://localhost:8080/ivis/oauth/token");
        resource.setScope(Arrays.asList("read"));
        resource.setUsername("admin");
        resource.setPassword("pass");
        int expired = 599;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, expired);
        Date ecxpirationDate = calendar.getTime();
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("read");
        DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken("acf95060-9303-4fbd-992a-c54157f16eab");
        accessToken.setTokenType("bearer");
        accessToken.setScope(scopes);
        accessToken.setRefreshToken((OAuth2RefreshToken)new DefaultExpiringOAuth2RefreshToken("fb99a06d-027d-4550-b969-f9bda5103e6d", ecxpirationDate));
        accessToken.setExpiration(ecxpirationDate);
        DefaultOAuth2ClientContext clientContext = new DefaultOAuth2ClientContext();
        clientContext.setAccessToken((OAuth2AccessToken)accessToken);
        try {
            IvisFacade.Configuration config = new IvisFacade.Configuration.Builder().endPointUrl("http://localhost:8080/ivis").build();
            IvisFacade facade = IvisFacade.instance(config);
            IvisServiceFactory serviceFactory = facade.getServiceFactory((OAuth2ProtectedResourceDetails)resource, (OAuth2ClientContext)clientContext);
            PupilService service = serviceFactory.getPupilService();
            System.out.println(service.findByPersonalId("850717-5019"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

