/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.entities.AbstractIdEntity;
import com.imcode.services.GenericService;
import imcode.services.restful.IvisServiceFactory;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

public abstract class AbstractOAuth2Service<T, ID>
implements GenericService<T, ID> {
    private String mainServiceAddres;
    private RestServiseRequest findAllRequest;
    private RestServiseRequest findRequest;
    private RestServiseRequest createRequest;
    private RestServiseRequest updateRequest;
    private RestServiseRequest existsRequest;
    private RestServiseRequest deleteRequest;
    private IvisServiceFactory factory;

    public AbstractOAuth2Service() {
    }

    public AbstractOAuth2Service(IvisServiceFactory factory, String mainServiceAddres) {
        this.factory = factory;
        this.fillServiseAdderess(mainServiceAddres);
    }

    public AbstractOAuth2Service(IvisServiceFactory factory) {
        this.factory = factory;
    }

    private OAuth2ProtectedResourceDetails getClient() {
        return this.factory.getClient();
    }

    private OAuth2ClientContext getClientContext() {
        return this.factory.getClientContext();
    }

    protected OAuth2RestTemplate getRestTemplate() {
        return new OAuth2RestTemplate(this.getClient(), this.getClientContext());
    }

    public T save(T entity) {
        Object result = null;
        AbstractIdEntity idEntity = (AbstractIdEntity)entity;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiseRequest request = null;
        Object[] uriVariables = null;
        if (idEntity.getId() == null) {
            request = this.getCreateRequest();
            String uri = request.getAddress();
            HttpMethod method = request.getMethod();
            result = restTemplate.postForObject(uri, entity, this.getGeneticType("T"), new Object[0]);
        } else {
            request = this.getUpdateRequest();
            uriVariables = new Object[]{idEntity.getId()};
            String uri = request.getAddress();
            HttpMethod method = request.getMethod();
            restTemplate.put(uri, entity, uriVariables);
        }
        return (T)result;
    }

    public T find(ID id) {
        HttpMethod method;
        Object result = null;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiseRequest request = null;
        request = this.getFindRequest();
        Object[] uriVariables = new Object[]{id};
        String uri = request.getAddress();
        ResponseEntity responseEntity = restTemplate.exchange(uri, method = request.getMethod(), null, this.getGeneticType("T"), uriVariables);
        if (responseEntity.getBody() != null) {
            result = responseEntity.getBody();
        }
        return (T)result;
    }

    public boolean exist(ID id) {
        boolean result = false;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiseRequest request = this.getExistsRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        Object[] uriVariables = new Object[]{id};
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, Boolean.class, uriVariables);
        if (responseEntity.getBody() != null) {
            result = (Boolean)responseEntity.getBody();
        }
        return result;
    }

    public void delete(ID id) {
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        RestServiseRequest request = this.getDeleteRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        Object[] uriVariables = new Object[]{id};
        restTemplate.exchange(uri, method, null, Void.TYPE, uriVariables);
    }

    public List<T> findAll() {
        ParameterizedTypeReference typeReference;
        LinkedList result = new LinkedList();
        RestServiseRequest request = this.getFindAllRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, typeReference = this.getListTypeReference(), new Object[0]);
        if (responseEntity.getBody() != null) {
            return (List)responseEntity.getBody();
        }
        return result;
    }

    private Class<T> getGeneticType(String variableName) {
        Map params = GenericTypeResolver.getTypeVariableMap(this.getClass());
        for (Map.Entry entry : params.entrySet()) {
            if (!((TypeVariable)entry.getKey()).getName().equals(variableName)) continue;
            return (Class)entry.getValue();
        }
        return null;
    }

    protected abstract ParameterizedTypeReference getListTypeReference();

    public String getMainServiceAddres() {
        return this.mainServiceAddres;
    }

    public void setMainServiceAddres(String mainServiceAddres) {
        this.mainServiceAddres = mainServiceAddres;
    }

    public RestServiseRequest getFindAllRequest() {
        return this.findAllRequest;
    }

    public void setFindAllRequest(RestServiseRequest findAllRequest) {
        this.findAllRequest = findAllRequest;
    }

    public RestServiseRequest getFindRequest() {
        return this.findRequest;
    }

    public void setFindRequest(RestServiseRequest findRequest) {
        this.findRequest = findRequest;
    }

    public RestServiseRequest getCreateRequest() {
        return this.createRequest;
    }

    public void setCreateRequest(RestServiseRequest createRequest) {
        this.createRequest = createRequest;
    }

    public RestServiseRequest getUpdateRequest() {
        return this.updateRequest;
    }

    public void setUpdateRequest(RestServiseRequest updateRequest) {
        this.updateRequest = updateRequest;
    }

    public RestServiseRequest getExistsRequest() {
        return this.existsRequest;
    }

    public void setExistsRequest(RestServiseRequest existsRequest) {
        this.existsRequest = existsRequest;
    }

    public RestServiseRequest getDeleteRequest() {
        return this.deleteRequest;
    }

    public void setDeleteRequest(RestServiseRequest deleteRequest) {
        this.deleteRequest = deleteRequest;
    }

    public void fillServiseAdderess(String mainServiceAddres) {
        this.mainServiceAddres = mainServiceAddres;
        this.createRequest = new RestServiseRequest(mainServiceAddres, HttpMethod.POST);
        this.findAllRequest = new RestServiseRequest(mainServiceAddres);
        this.findRequest = new RestServiseRequest(mainServiceAddres + "/{id}");
        this.existsRequest = new RestServiseRequest(this.findRequest.address);
        this.updateRequest = new RestServiseRequest(this.findRequest.address, HttpMethod.PUT);
        this.deleteRequest = new RestServiseRequest(this.findRequest.address, HttpMethod.DELETE);
    }

    public static class RestServiseRequest {
        private static final HttpMethod DEFAULT_METHOD = HttpMethod.GET;
        private String address;
        private HttpMethod method = DEFAULT_METHOD;

        public RestServiseRequest() {
        }

        public RestServiseRequest(String address) {
            this.address = address;
        }

        public RestServiseRequest(String address, HttpMethod method) {
            this.address = address;
            this.method = method;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

