/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import imcode.services.restful.IvisServiceFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class AbstractOAuth2Service {
    private String mainServiceAddres;
    private RestServiseRequest findAllRequest;
    private RestServiseRequest findRequest;
    private RestServiseRequest createRequest;
    private RestServiseRequest updateRequest;
    private RestServiseRequest existsRequest;
    private RestServiseRequest deleteRequest;
    private OAuth2AccessToken accessToken;
    private OAuth2ProtectedResourceDetails client;

    public AbstractOAuth2Service() {
    }

    public AbstractOAuth2Service(OAuth2ProtectedResourceDetails client, OAuth2AccessToken accessToken, String mainServiceAddres) {
        this.client = client;
        this.accessToken = accessToken;
        this.fillServiseAdderess(mainServiceAddres);
    }

    public AbstractOAuth2Service(IvisServiceFactory ivisServiceFactory) {
        this.setClient(ivisServiceFactory.getClient());
        this.setAccessToken(ivisServiceFactory.getAccessToken());
    }

    public OAuth2ProtectedResourceDetails getClient() {
        return this.client;
    }

    protected OAuth2RestTemplate getRestTemplate() {
        DefaultOAuth2ClientContext clientContext = new DefaultOAuth2ClientContext(this.accessToken);
        return new OAuth2RestTemplate(this.client, (OAuth2ClientContext)clientContext);
    }

    public void setClient(OAuth2ProtectedResourceDetails client) {
        this.client = client;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public String getMainServiceAddres() {
        return this.mainServiceAddres;
    }

    public void setMainServiceAddres(String mainServiceAddres) {
        this.mainServiceAddres = mainServiceAddres;
    }

    public RestServiseRequest getFindAllRequest() {
        return this.findAllRequest;
    }

    public void setFindAllRequest(RestServiseRequest findAllRequest) {
        this.findAllRequest = findAllRequest;
    }

    public RestServiseRequest getFindRequest() {
        return this.findRequest;
    }

    public void setFindRequest(RestServiseRequest findRequest) {
        this.findRequest = findRequest;
    }

    public RestServiseRequest getCreateRequest() {
        return this.createRequest;
    }

    public void setCreateRequest(RestServiseRequest createRequest) {
        this.createRequest = createRequest;
    }

    public RestServiseRequest getUpdateRequest() {
        return this.updateRequest;
    }

    public void setUpdateRequest(RestServiseRequest updateRequest) {
        this.updateRequest = updateRequest;
    }

    public RestServiseRequest getExistsRequest() {
        return this.existsRequest;
    }

    public void setExistsRequest(RestServiseRequest existsRequest) {
        this.existsRequest = existsRequest;
    }

    public RestServiseRequest getDeleteRequest() {
        return this.deleteRequest;
    }

    public void setDeleteRequest(RestServiseRequest deleteRequest) {
        this.deleteRequest = deleteRequest;
    }

    public void fillServiseAdderess(String mainServiceAddres) {
        this.mainServiceAddres = mainServiceAddres;
        this.createRequest = new RestServiseRequest(mainServiceAddres, HttpMethod.POST);
        this.findAllRequest = new RestServiseRequest(mainServiceAddres);
        this.findRequest = new RestServiseRequest(mainServiceAddres + "/{id}");
        this.existsRequest = new RestServiseRequest(this.findRequest.address);
        this.updateRequest = new RestServiseRequest(this.findRequest.address, HttpMethod.PUT);
        this.deleteRequest = new RestServiseRequest(this.findRequest.address, HttpMethod.DELETE);
    }

    public static class RestServiseRequest {
        private static final HttpMethod DEFAULT_METHOD = HttpMethod.GET;
        private String address;
        private HttpMethod method = DEFAULT_METHOD;

        public RestServiseRequest() {
        }

        public RestServiseRequest(String address) {
            this.address = address;
        }

        public RestServiseRequest(String address, HttpMethod method) {
            this.address = address;
            this.method = method;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

