/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import com.imcode.entities.Statement;
import com.imcode.services.StatementService;
import imcode.services.restful.AbstractOAuth2Service;
import imcode.services.restful.IvisServiceFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class OAuth2StatementService
extends AbstractOAuth2Service
implements StatementService {
    public OAuth2StatementService() {
    }

    public OAuth2StatementService(OAuth2ProtectedResourceDetails client, OAuth2AccessToken accessToken, String mainServiceAddres) {
        super(client, accessToken, mainServiceAddres);
    }

    public OAuth2StatementService(IvisServiceFactory ivisServiceFactory) {
        super(ivisServiceFactory);
    }

    public Statement save(Statement entity) {
        Statement result = null;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        AbstractOAuth2Service.RestServiseRequest request = null;
        Object[] uriVariables = null;
        if (entity.getId() == null) {
            request = this.getCreateRequest();
            String uri = request.getAddress();
            HttpMethod method = request.getMethod();
            Statement statement = (Statement)restTemplate.postForObject(uri, (Object)entity, Statement.class, uriVariables);
        } else {
            request = this.getUpdateRequest();
            uriVariables = new Object[]{entity.getId()};
            String uri = request.getAddress();
            HttpMethod method = request.getMethod();
            restTemplate.put(uri, (Object)entity, uriVariables);
        }
        return result;
    }

    public Statement find(Long id) {
        HttpMethod method;
        Statement result = null;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        AbstractOAuth2Service.RestServiseRequest request = null;
        request = this.getFindRequest();
        Object[] uriVariables = new Object[]{id};
        String uri = request.getAddress();
        ResponseEntity responseEntity = restTemplate.exchange(uri, method = request.getMethod(), null, Statement.class, uriVariables);
        if (responseEntity.getBody() != null) {
            result = (Statement)responseEntity.getBody();
        }
        return result;
    }

    public boolean exist(Long id) {
        boolean result = false;
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        AbstractOAuth2Service.RestServiseRequest request = this.getExistsRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        Object[] uriVariables = new Object[]{id};
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, Boolean.class, uriVariables);
        if (responseEntity.getBody() != null) {
            result = (Boolean)responseEntity.getBody();
        }
        return result;
    }

    public void delete(Long id) {
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        AbstractOAuth2Service.RestServiseRequest request = this.getDeleteRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        Object[] uriVariables = new Object[]{id};
        restTemplate.exchange(uri, method, null, Void.TYPE, uriVariables);
    }

    public List<Statement> findAll() {
        List<Object> result = Collections.emptyList();
        AbstractOAuth2Service.RestServiseRequest request = this.getFindAllRequest();
        String uri = request.getAddress();
        HttpMethod method = request.getMethod();
        OAuth2RestTemplate restTemplate = this.getRestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(uri, method, null, Statement[].class, new Object[0]);
        if (responseEntity.getBody() != null) {
            result = Arrays.asList((Object[])responseEntity.getBody());
        }
        return result;
    }
}

