/*
 * Decompiled with CFR 0.152.
 */
package imcode.services.restful;

import imcode.services.restful.IvisServiceFactory;
import java.util.regex.Pattern;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class IvisFacade {
    private static volatile IvisFacade singleton = null;
    private volatile Configuration configuration = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IvisFacade instance() {
        if (singleton != null) return singleton;
        Class<IvisFacade> clazz = IvisFacade.class;
        synchronized (IvisFacade.class) {
            if (singleton != null) return singleton;
            singleton = new IvisFacade();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IvisFacade instance(Configuration configuration) {
        Class<IvisFacade> clazz;
        if (singleton == null) {
            clazz = IvisFacade.class;
            // MONITORENTER : imcode.services.restful.IvisFacade.class
            if (singleton == null) {
                singleton = new IvisFacade();
            }
            // MONITOREXIT : clazz
        }
        clazz = IvisFacade.class;
        // MONITORENTER : imcode.services.restful.IvisFacade.class
        IvisFacade.singleton.configuration = configuration;
        // MONITOREXIT : clazz
        return singleton;
    }

    protected IvisFacade() {
    }

    public IvisServiceFactory getServiceFactory(OAuth2ProtectedResourceDetails client, OAuth2AccessToken accessToken) {
        return new IvisServiceFactory(String.format("%s/api/%s/%s/", this.configuration.endPointUrl, this.configuration.version, this.configuration.responseType), client, accessToken);
    }

    public static class Configuration {
        public String endPointUrl = "http://ivis.dev.imcode.com";
        public String version = "v1";
        public String responseType = "json";

        public static class Builder {
            private Configuration configuration = new Configuration();

            public Builder endPointUrl(String endPointUrl) {
                this.configuration.endPointUrl = endPointUrl;
                return this;
            }

            public Builder version(String version) {
                this.configuration.version = version;
                return this;
            }

            public Builder responseType(String responseType) {
                this.configuration.responseType = responseType;
                return this;
            }

            public Configuration build() {
                Pattern pattern = Pattern.compile("./$");
                this.configuration.endPointUrl = pattern.matcher(this.configuration.endPointUrl).replaceAll("");
                this.configuration.version = pattern.matcher(this.configuration.version).replaceAll("");
                this.configuration.responseType = pattern.matcher(this.configuration.responseType).replaceAll("");
                return this.configuration;
            }
        }
    }
}

