/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.oauth2.modules.foreground;

import imcode.services.IvisServiceFactory;
import java.sql.Timestamp;
import java.util.Collection;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.i18n.Language;

@Table(name="simple_users")
public class IvisOAuth2User<UserType extends User>
extends User {
    public static final String IVIS_ATTRIBUTE_NAME = "ivisUserId";
    private UserType user;
    private IvisServiceFactory serviceFactory;
    private OAuth2ClientContext clientContext;

    public IvisOAuth2User(UserType user, IvisServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.clientContext = serviceFactory.getClientContext();
        this.user = user;
    }

    public UserType getUser() {
        return this.user;
    }

    public void setUser(UserType user) {
        this.user = user;
    }

    public IvisServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(IvisServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public OAuth2ClientContext getClientContext() {
        return this.clientContext;
    }

    public void setClientContext(OAuth2ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public String getFirstname() {
        return this.user.getFirstname();
    }

    public Timestamp getCurrentLogin() {
        return this.user.getCurrentLogin();
    }

    public Timestamp getLastLogin() {
        return this.user.getLastLogin();
    }

    public String getLastname() {
        return this.user.getLastname();
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public Integer getUserID() {
        return this.user.getUserID();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public Timestamp getAdded() {
        return this.user.getAdded();
    }

    public Collection<Group> getGroups() {
        return this.user.getGroups();
    }

    public Language getLanguage() {
        return this.user.getLanguage();
    }

    public String getPreferedDesign() {
        return this.user.getPreferedDesign();
    }

    public boolean hasFormProvider() {
        return this.user.hasFormProvider();
    }

    public void setCurrentLogin(Timestamp currentLogin) {
        this.user.setCurrentLogin(currentLogin);
    }
}

