/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.oauth2.modules.foreground;

import com.imcode.entities.User;
import com.imcode.oeplatform.oauth2.modules.foreground.GroupPopulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.handlers.GroupHandler;

public class ByNameGroupPopulator
implements GroupPopulator<User, Group> {
    private Set<Group> defaultGroupSet;
    private Map<String, List<String>> groupNameMap;
    private GroupHandler groupHandler;

    public ByNameGroupPopulator(GroupHandler groupHandler, Map<String, List<String>> groupNameMap, Set<Group> defaultGroupSet) {
        this.defaultGroupSet = defaultGroupSet;
        this.groupNameMap = groupNameMap;
        this.groupHandler = groupHandler;
    }

    public ByNameGroupPopulator(GroupHandler groupHandler, Map<String, List<String>> groupNameMap) {
        this(groupHandler, groupNameMap, Collections.emptySet());
    }

    @Override
    public List<Group> populate(User sourceUser) {
        LinkedHashSet<Group> groupSet = new LinkedHashSet<Group>(this.defaultGroupSet);
        Set roleList = sourceUser.getAuthorities();
        ArrayList allGroups = this.groupHandler.getGroups(false);
        if (roleList != null) {
            HashSet groupNames = new HashSet();
            roleList.stream().filter(role -> this.groupNameMap.containsKey(role.getName())).forEach(role -> groupNames.addAll(this.groupNameMap.get(role.getName())));
            allGroups.stream().filter(group -> groupNames.contains(group.getName())).forEach(group -> groupSet.add((Group)group));
        }
        return new ArrayList<Group>(groupSet);
    }

    public Set<Group> getDefaultGroupSet() {
        return this.defaultGroupSet;
    }

    public void setDefaultGroupSet(Set<Group> defaultGroupSet) {
        this.defaultGroupSet = defaultGroupSet;
    }

    public Map<String, List<String>> getGroupNameMap() {
        return this.groupNameMap;
    }

    public void setGroupNameMap(Map<String, List<String>> groupNameMap) {
        this.groupNameMap = groupNameMap;
    }
}

