/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.checkboxquery;

import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxAlternative;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQuery;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQueryCRUD;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.CheckboxQueryInstance;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.validationerrors.TooFewAlternativesSelectedValidationError;
import com.imcode.oeplatform.flowengine.queries.checkboxquery.validationerrors.TooManyAlternativesSelectedValidationError;
import com.nordicpeak.flowengine.enums.QueryState;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.InstanceMetadata;
import com.nordicpeak.flowengine.interfaces.MutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.MutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.Query;
import com.nordicpeak.flowengine.interfaces.QueryInstance;
import com.nordicpeak.flowengine.populators.FreeTextAlternativePopulator;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUDCallback;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryInstance;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryProviderModule;
import com.nordicpeak.flowengine.queries.fixedalternativesquery.FixedAlternativeQueryUtils;
import com.nordicpeak.flowengine.queries.fixedalternativesquery.FixedAlternativesQuery;
import com.nordicpeak.flowengine.queries.fixedalternativesquery.FixedAlternativesQueryCallback;
import com.nordicpeak.flowengine.queries.tablequery.SummaryTableQueryCallback;
import com.nordicpeak.flowengine.utils.JTidyUtils;
import com.nordicpeak.flowengine.utils.TextTagReplacer;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.annotations.XSLVariable;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.utils.FCKUtils;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfile;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.datatypes.Matrix;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLGenerator;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;
import se.unlogic.webutils.url.URLRewriter;

public class CheckboxQueryProviderModule
extends BaseQueryProviderModule<CheckboxQueryInstance>
implements BaseQueryCRUDCallback,
FixedAlternativesQueryCallback<CheckboxQuery>,
SummaryTableQueryCallback<CheckboxQuery> {
    private static final RelationQuery SAVE_QUERY_INSTANCE_RELATION_QUERY = new RelationQuery(new Field[]{CheckboxQueryInstance.ALTERNATIVES_RELATION});
    @XSLVariable(prefix="java.")
    private String countText = "Count";
    @XSLVariable(prefix="java.")
    private String alternativesText = "Alternative";
    private AnnotatedDAO<CheckboxQuery> queryDAO;
    private AnnotatedDAO<CheckboxQueryInstance> queryInstanceDAO;
    private CheckboxQueryCRUD queryCRUD;
    private QueryParameterFactory<CheckboxQuery, Integer> queryIDParamFactory;
    private QueryParameterFactory<CheckboxQueryInstance, Integer> queryInstanceIDParamFactory;
    private QueryParameterFactory<CheckboxQueryInstance, CheckboxQuery> queryInstanceQueryParamFactory;

    protected void createDAOs(DataSource dataSource) throws Exception {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)CheckboxQueryProviderModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(((Object)((Object)this)).getClass().getResourceAsStream("DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        SimpleAnnotatedDAOFactory daoFactory = new SimpleAnnotatedDAOFactory(dataSource);
        this.queryDAO = daoFactory.getDAO(CheckboxQuery.class);
        this.queryInstanceDAO = daoFactory.getDAO(CheckboxQueryInstance.class);
        this.queryCRUD = new CheckboxQueryCRUD((AnnotatedDAOWrapper<CheckboxQuery, Integer>)this.queryDAO.getWrapper(Integer.class), (BeanRequestPopulator<CheckboxQuery>)new AnnotatedRequestPopulator(CheckboxQuery.class), "CheckboxQuery", "query", null, this);
        this.queryIDParamFactory = this.queryDAO.getParamFactory("queryID", Integer.class);
        this.queryInstanceIDParamFactory = this.queryInstanceDAO.getParamFactory("queryInstanceID", Integer.class);
        this.queryInstanceQueryParamFactory = this.queryInstanceDAO.getParamFactory("query", CheckboxQuery.class);
    }

    public Query createQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        CheckboxQuery query = new CheckboxQuery();
        query.setQueryID(descriptor.getQueryID());
        this.queryDAO.add((Object)query, transactionHandler, null);
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query importQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        CheckboxQuery query = new CheckboxQuery();
        query.setQueryID(descriptor.getQueryID());
        query.populate(descriptor.getImportParser().getNode(XMLGenerator.getElementName(((Object)((Object)query)).getClass())));
        List oldAlternativeIDs = FixedAlternativeQueryUtils.getAlternativeIDs((FixedAlternativesQuery)query);
        FixedAlternativeQueryUtils.clearAlternativeIDs(query.getAlternatives());
        this.queryDAO.add((Object)query, transactionHandler, null);
        query.setAlternativeConversionMap(FixedAlternativeQueryUtils.getAlternativeConversionMap(query.getAlternatives(), (List)oldAlternativeIDs));
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor) throws SQLException {
        CheckboxQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        CheckboxQuery query = this.getQuery(descriptor.getQueryID(), transactionHandler);
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public QueryInstance getQueryInstance(MutableQueryInstanceDescriptor descriptor, String instanceManagerID, HttpServletRequest req, User user, InstanceMetadata instanceMetadata) throws SQLException {
        CheckboxQueryInstance queryInstance = null;
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance = new CheckboxQueryInstance();
        } else {
            queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
            if (queryInstance == null) {
                return null;
            }
        }
        queryInstance.setQuery(this.getQuery(descriptor.getQueryDescriptor().getQueryID()));
        if (queryInstance.getQuery() == null) {
            return null;
        }
        if (req != null) {
            FCKUtils.setAbsoluteFileUrls((Object)((Object)queryInstance.getQuery()), (String)(RequestUtils.getFullContextPathURL((HttpServletRequest)req) + this.ckConnectorModuleAlias));
            URLRewriter.setAbsoluteLinkUrls((Object)((Object)queryInstance.getQuery()), (HttpServletRequest)req, (boolean)true);
        }
        TextTagReplacer.replaceTextTags((Object)((Object)queryInstance.getQuery()), (SiteProfile)instanceMetadata.getSiteProfile());
        queryInstance.set(descriptor);
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance.copyQueryValues();
        }
        return queryInstance;
    }

    private CheckboxQuery getQuery(Integer queryID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{CheckboxQuery.ALTERNATIVES_RELATION});
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        return (CheckboxQuery)((Object)this.queryDAO.get(query));
    }

    private CheckboxQuery getQuery(Integer queryID, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{CheckboxQuery.ALTERNATIVES_RELATION});
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        return (CheckboxQuery)((Object)this.queryDAO.get(query, transactionHandler));
    }

    private CheckboxQueryInstance getQueryInstance(Integer queryInstanceID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{CheckboxQueryInstance.ALTERNATIVES_RELATION, CheckboxQueryInstance.QUERY_RELATION});
        query.addParameter(this.queryInstanceIDParamFactory.getParameter((Object)queryInstanceID));
        return (CheckboxQueryInstance)((Object)this.queryInstanceDAO.get(query));
    }

    public void save(CheckboxQueryInstance queryInstance, TransactionHandler transactionHandler) throws Throwable {
        if (queryInstance.getQueryInstanceID() == null || !queryInstance.getQueryInstanceID().equals(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID())) {
            queryInstance.setQueryInstanceID(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID());
            this.queryInstanceDAO.add((Object)queryInstance, transactionHandler, SAVE_QUERY_INSTANCE_RELATION_QUERY);
        } else {
            this.queryInstanceDAO.update((Object)queryInstance, transactionHandler, SAVE_QUERY_INSTANCE_RELATION_QUERY);
        }
    }

    public void populate(CheckboxQueryInstance queryInstance, HttpServletRequest req, User user, boolean allowPartialPopulation, MutableAttributeHandler attributeHandler) throws ValidationException {
        List<CheckboxAlternative> availableAlternatives = queryInstance.getQuery().getAlternatives();
        if (CollectionUtils.isEmpty(availableAlternatives)) {
            queryInstance.reset(attributeHandler);
            return;
        }
        ArrayList<CheckboxAlternative> selectedAlternatives = new ArrayList<CheckboxAlternative>(queryInstance.getQuery().getAlternatives().size());
        for (CheckboxAlternative alternative : availableAlternatives) {
            if (req.getParameter("q" + queryInstance.getQuery().getQueryID() + "_alternative" + alternative.getAlternativeID()) == null) continue;
            selectedAlternatives.add(alternative);
        }
        int alternativesSelected = selectedAlternatives.size();
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String freeTextAlternativeValue = FreeTextAlternativePopulator.populate((Integer)queryInstance.getQuery().getQueryID(), (String)"_freeTextAlternative", (HttpServletRequest)req, validationErrors);
        if (freeTextAlternativeValue != null) {
            ++alternativesSelected;
        }
        if (allowPartialPopulation) {
            if (alternativesSelected == 0) {
                queryInstance.setAlternatives(null);
                queryInstance.setFreeTextAlternativeValue(null);
                queryInstance.getQueryInstanceDescriptor().setPopulated(false);
            } else {
                queryInstance.setAlternatives(selectedAlternatives);
                queryInstance.setFreeTextAlternativeValue(freeTextAlternativeValue);
                queryInstance.getQueryInstanceDescriptor().setPopulated(true);
            }
            return;
        }
        if (queryInstance.getQueryInstanceDescriptor().getQueryState() == QueryState.VISIBLE_REQUIRED || alternativesSelected != 0) {
            if (queryInstance.getMinChecked() != null && alternativesSelected < queryInstance.getMinChecked()) {
                validationErrors.add(new TooFewAlternativesSelectedValidationError(alternativesSelected, queryInstance.getMinChecked()));
            } else if (queryInstance.getMaxChecked() != null && alternativesSelected > queryInstance.getMaxChecked()) {
                validationErrors.add(new TooManyAlternativesSelectedValidationError(alternativesSelected, queryInstance.getMaxChecked()));
            } else if (queryInstance.getQueryInstanceDescriptor().getQueryState() == QueryState.VISIBLE_REQUIRED && alternativesSelected == 0) {
                validationErrors.add(new ValidationError("RequiredQuery"));
            }
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        queryInstance.setFreeTextAlternativeValue(freeTextAlternativeValue);
        queryInstance.setAlternatives(selectedAlternatives);
        queryInstance.getQueryInstanceDescriptor().setPopulated(!selectedAlternatives.isEmpty());
    }

    @WebPublic(alias="config")
    public ForegroundModuleResponse configureQuery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.queryCRUD.update(req, res, user, uriParser);
    }

    public boolean deleteQuery(ImmutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        CheckboxQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return false;
        }
        this.queryDAO.delete((Object)query, transactionHandler);
        return true;
    }

    public boolean deleteQueryInstance(ImmutableQueryInstanceDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        CheckboxQueryInstance queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
        if (queryInstance == null) {
            return false;
        }
        this.queryInstanceDAO.delete((Object)queryInstance, transactionHandler);
        return true;
    }

    public String getTitlePrefix() {
        return ((ForegroundModuleDescriptor)this.moduleDescriptor).getName();
    }

    public void copyQuery(MutableQueryDescriptor sourceQueryDescriptor, MutableQueryDescriptor copyQueryDescriptor, TransactionHandler transactionHandler) throws SQLException {
        CheckboxQuery query = this.getQuery(sourceQueryDescriptor.getQueryID(), transactionHandler);
        query.setQueryID(copyQueryDescriptor.getQueryID());
        if (query.getAlternatives() != null) {
            for (CheckboxAlternative alternative : query.getAlternatives()) {
                alternative.setAlternativeID(null);
            }
        }
        this.queryDAO.add((Object)query, transactionHandler, new RelationQuery(new Field[]{CheckboxQuery.ALTERNATIVES_RELATION}));
    }

    public List<CheckboxQueryInstance> getQueryInstances(CheckboxQuery checkboxQuery, List<Integer> queryInstanceIDs) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addRelation(CheckboxQueryInstance.ALTERNATIVES_RELATION);
        query.addParameter(this.queryInstanceQueryParamFactory.getParameter((Object)checkboxQuery));
        query.addParameter(this.queryInstanceIDParamFactory.getWhereInParameter(queryInstanceIDs));
        return this.queryInstanceDAO.getAll(query);
    }

    public Matrix<String> getSummaryTable(CheckboxQuery query, List<Integer> queryInstanceIDs) throws SQLException {
        if (query.getAlternatives() == null) {
            return null;
        }
        List<CheckboxQueryInstance> instances = queryInstanceIDs != null ? this.getQueryInstances(query, queryInstanceIDs) : null;
        Matrix table = new Matrix(query.getFreeTextAlternative() != null ? query.getAlternatives().size() + 2 : query.getAlternatives().size() + 1, 2);
        table.setCell(0, 0, (Object)this.alternativesText);
        table.setCell(0, 1, (Object)this.countText);
        int currentRow = 1;
        for (CheckboxAlternative alternative : query.getAlternatives()) {
            table.setCell(currentRow, 0, (Object)alternative.getName());
            int selectionCount = 0;
            if (instances != null) {
                for (CheckboxQueryInstance instance : instances) {
                    if (instance.getAlternatives() == null || !instance.getAlternatives().contains(alternative)) continue;
                    ++selectionCount;
                }
            }
            table.setCell(currentRow, 1, (Object)String.valueOf(selectionCount));
            ++currentRow;
        }
        if (query.getFreeTextAlternative() != null) {
            table.setCell(currentRow, 0, (Object)query.getFreeTextAlternative());
            int selectionCount = 0;
            if (instances != null) {
                for (CheckboxQueryInstance instance : instances) {
                    if (instance.getFreeTextAlternativeValue() == null) continue;
                    ++selectionCount;
                }
            }
            table.setCell(currentRow, 1, (Object)String.valueOf(selectionCount));
        }
        return table;
    }

    protected void appendPDFData(Document doc, Element showQueryValuesElement, CheckboxQueryInstance queryInstance) {
        super.appendPDFData(doc, showQueryValuesElement, (BaseQueryInstance)queryInstance);
        if (queryInstance.getQuery().getDescription() != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"Description", (String)JTidyUtils.getXHTML((String)queryInstance.getQuery().getDescription()));
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"isHTMLDescription", (Object)(queryInstance.getQuery().getDescription().contains("<") && queryInstance.getQuery().getDescription().contains(">") ? 1 : 0));
        }
    }
}

