/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.entity.application;

import com.imcode.entities.interfaces.JpaEntity;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.StringUtils;

public class StringIdToEntityConverter<T extends ConversionService & ConverterRegistry>
implements ConditionalGenericConverter {
    private final T conversionService;
    private ToEntityConverter toEntityConverter;

    public StringIdToEntityConverter(T conversionService) {
        Objects.requireNonNull(conversionService, "ConversionService must not be null!");
        this.conversionService = conversionService;
        ((ConverterRegistry)conversionService).addConverter((GenericConverter)this.toEntityConverter);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, JpaEntity.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.toEntityConverter.convert(source, sourceType, targetType);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.toEntityConverter.matches(sourceType, targetType);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final class ToEntityConverter<TT extends ConversionService & ConverterRegistry>
    implements ConditionalGenericConverter {
        private final TT conversionService1;

        public ToEntityConverter(TT conversionService1) {
            this.conversionService1 = conversionService1;
            ((ConverterRegistry)conversionService1).addConverter((GenericConverter)this);
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, JpaEntity.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source != null && StringUtils.hasText((String)source.toString())) {
                if (sourceType.equals((Object)targetType)) {
                    return source;
                }
                Class domainType = targetType.getType();
                return null;
            }
            return null;
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (sourceType.isAssignableTo(targetType)) {
                return false;
            }
            if (!JpaEntity.class.isAssignableFrom(targetType.getType())) {
                return false;
            }
            Class<Long> rawIdType = Long.class;
            return true;
        }
    }
}

