/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine;

import com.imcode.entities.Application;
import com.imcode.entities.ApplicationForm;
import com.imcode.entities.ApplicationFormQuestionGroup;
import com.imcode.entities.ApplicationFormStep;
import com.imcode.entities.EntityVersion;
import com.imcode.entities.embed.Decision;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.oeplatform.flowengine.populators.entity.ApplicationFormFactory;
import com.imcode.oeplatform.flowengine.populators.entity.FieldQuestionMapper;
import com.imcode.oeplatform.flowengine.populators.entity.MultipleAlternativeQuestionMapper;
import com.imcode.oeplatform.flowengine.populators.entity.SingleAlternativeQuestionMapper;
import com.imcode.oeplatform.flowengine.populators.entity.TextAreaQuestionMapper;
import com.imcode.oeplatform.flowengine.populators.entity.application.ApplicationPopulator;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQueryInstance;
import com.imcode.oeplatform.oauth2.modules.foreground.IvisOAuth2User;
import com.imcode.services.ApplicationFormQuestionGroupService;
import com.imcode.services.ApplicationFormQuestionService;
import com.imcode.services.ApplicationFormService;
import com.imcode.services.ApplicationFormStepService;
import com.imcode.services.ApplicationService;
import com.imcode.services.EntityVersionService;
import com.nordicpeak.flowengine.beans.FlowInstanceEvent;
import com.nordicpeak.flowengine.beans.QueryDescriptor;
import com.nordicpeak.flowengine.beans.Step;
import com.nordicpeak.flowengine.dao.FlowEngineDAOFactory;
import com.nordicpeak.flowengine.enums.EventType;
import com.nordicpeak.flowengine.events.SubmitEvent;
import com.nordicpeak.flowengine.interfaces.ImmutableFlowInstance;
import com.nordicpeak.flowengine.interfaces.QueryHandler;
import com.nordicpeak.flowengine.managers.FlowInstanceManager;
import imcode.services.IvisServiceFactory;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import se.unlogic.hierarchy.core.annotations.EventListener;
import se.unlogic.hierarchy.core.annotations.InstanceManagerDependency;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.PasswordSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.enums.EventSource;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.date.PooledSimpleDateFormat;

public class IvisModule
extends AnnotatedForegroundModule {
    public static final RelationQuery EVENT_ATTRIBUTE_RELATION_QUERY = new RelationQuery(new Field[]{FlowInstanceEvent.ATTRIBUTES_RELATION});
    private static final PooledSimpleDateFormat DATE_TIME_FORMATTER = new PooledSimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static final String DEFAULT_ACCESS_TOKEN_URI = "/oauth/token";
    private static final String CLIENT_CONTEXT_PARAM = "OAuth2ClientContext";
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Supported actionID's", description="The action ID's which will trigger export XML to be generated and stored when a submit event is detected")
    protected List<String> supportedActionIDs;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="OAUTH2 token", description="Registred OAUTH2 token")
    protected String oauthToken;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server Url", description="iVIS server url \"http://localhost:8080\"", required=true)
    protected String serverUrl;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Client id", description="iVIS client id", required=true)
    protected String clientId;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Client secret", description="iVIS secret", required=true)
    protected String clientSecret;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Server username", description="iVIS server username to retrive access token", required=true)
    protected String username;
    @ModuleSetting
    @PasswordSettingDescriptor(name="Server password", description="iVIS server user password", required=true)
    protected String password;
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Flow instance to Application mapping", description="", required=false)
    protected String flowToApplicationMapping;
    @InstanceManagerDependency(required=true)
    protected QueryHandler queryHandler;
    private FlowEngineDAOFactory daoFactory;

    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
    }

    public void unload() throws Exception {
        super.unload();
    }

    protected void createDAOs(DataSource dataSource) throws Exception {
        this.daoFactory = new FlowEngineDAOFactory(dataSource, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
    }

    @EventListener(channel=FlowInstanceManager.class, priority=51)
    public void processEvent(SubmitEvent event, EventSource eventSource) throws Exception {
        IvisOAuth2User user = null;
        if (event.getEvent().getFlowInstance().getPoster() instanceof IvisOAuth2User) {
            user = (IvisOAuth2User)event.getEvent().getFlowInstance().getPoster();
        } else if (event.getEvent().getFlowInstance().getEditor() instanceof IvisOAuth2User) {
            user = (IvisOAuth2User)event.getEvent().getFlowInstance().getEditor();
        } else {
            this.log.warn((Object)("User \"" + (Object)((Object)user) + "\" is not authorized in iVIS/"));
            return;
        }
        if (this.supportedActionIDs == null) {
            this.log.warn((Object)("Module " + this.moduleDescriptor + " not properly configured, can not connect to server"));
        }
        if (event.getEvent().getEventType() != EventType.SUBMITTED || event.getActionID() == null || !this.supportedActionIDs.contains(event.getActionID()) || user == null) {
            return;
        }
        FlowInstanceManager flowInstanceManager = event.getFlowInstanceManager();
        ImmutableFlowInstance flowInstance = flowInstanceManager.getFlowInstance();
        this.log.info((Object)("Creating Application instance for flow instance " + flowInstance));
        Application application = new Application();
        application.setRegistrationNumber(Long.valueOf(flowInstance.getFlowInstanceID().longValue()));
        application.setDecision(new Decision());
        ApplicationFormFactory factory = new ApplicationFormFactory();
        factory.addMapper(FieldQuestionMapper.forClass(TextFieldQueryInstance.class));
        factory.addMapper(FieldQuestionMapper.forClass(com.imcode.oeplatform.flowengine.queries.textfieldquery2.TextFieldQueryInstance.class));
        factory.addMapper(new SingleAlternativeQuestionMapper());
        factory.addMapper(new MultipleAlternativeQuestionMapper());
        factory.addMapper(new TextAreaQuestionMapper());
        this.populateSteps(flowInstance);
        ApplicationForm form = factory.get(flowInstanceManager);
        IvisServiceFactory ivisServiceFactory = user.getServiceFactory();
        application.setApplicationForm(form);
        this.saveApplication(application, ivisServiceFactory);
    }

    private void saveApplication1(Application application, IvisServiceFactory ivisServiceFactory) {
        ApplicationPopulator.saveObjectToFile(application, "/home/vitaly/SkypeFiles/Application.dat");
    }

    private void populateSteps(ImmutableFlowInstance flowInstance) {
        List steps = flowInstance.getFlow().getSteps();
        for (Step step : steps) {
            List queryDescriptors = step.getQueryDescriptors();
            for (QueryDescriptor descriptor : queryDescriptors) {
                descriptor.setStep(step);
            }
        }
    }

    public List<String> getSupportedActionIDs() {
        return this.supportedActionIDs;
    }

    public void setSupportedActionIDs(List<String> supportedActionIDs) {
        this.supportedActionIDs = supportedActionIDs;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public void setQueryHandler(QueryHandler queryHandler) {
        this.queryHandler = queryHandler;
    }

    public FlowEngineDAOFactory getDaoFactory() {
        return this.daoFactory;
    }

    public void setDaoFactory(FlowEngineDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    private OAuth2ClientContext getClientContext(HttpServletRequest request) {
        Object value = request.getSession().getAttribute(CLIENT_CONTEXT_PARAM);
        if (value instanceof OAuth2ClientContext) {
            return (OAuth2ClientContext)value;
        }
        return null;
    }

    private void saveApplication(Application application, IvisServiceFactory ivisServiceFactory) {
        ApplicationService applicationService = (ApplicationService)ivisServiceFactory.getService(ApplicationService.class);
        ApplicationFormService formService = (ApplicationFormService)ivisServiceFactory.getService(ApplicationFormService.class);
        ApplicationFormStepService stepService = (ApplicationFormStepService)ivisServiceFactory.getService(ApplicationFormStepService.class);
        ApplicationFormQuestionGroupService groupService = (ApplicationFormQuestionGroupService)ivisServiceFactory.getService(ApplicationFormQuestionGroupService.class);
        ApplicationFormQuestionService questionService = (ApplicationFormQuestionService)ivisServiceFactory.getService(ApplicationFormQuestionService.class);
        EntityVersionService versionService = (EntityVersionService)ivisServiceFactory.getService(EntityVersionService.class);
        try {
            ApplicationForm newForm = application.getApplicationForm();
            ApplicationForm form = (ApplicationForm)formService.save((Object)newForm);
            application.setApplicationForm(form);
            application = (Application)applicationService.save((Object)application);
            List steps = form.getSteps().stream().peek(step1 -> step1.setApplicationForm(form)).collect(Collectors.toList());
            Iterator savedSteps = stepService.save(steps).iterator();
            for (ApplicationFormStep step2 : steps) {
                ApplicationFormStep savedStep = (ApplicationFormStep)savedSteps.next();
                step2.getQuestionGroups().stream().forEach(group -> group.setStep(savedStep));
            }
            List groups = steps.stream().flatMap(step -> step.getQuestionGroups().stream()).collect(Collectors.toList());
            Iterator savedGroups = groupService.save(groups).iterator();
            for (ApplicationFormQuestionGroup group2 : groups) {
                ApplicationFormQuestionGroup savedGroup = (ApplicationFormQuestionGroup)savedGroups.next();
                group2.getQuestions().stream().forEach(question -> question.setQuestionGroup(savedGroup));
            }
            List questions = groups.stream().flatMap(group -> group.getQuestions().stream()).collect(Collectors.toList());
            Iterable savedQuestions = questionService.save(questions);
            EntityVersion version = new EntityVersion((JpaEntity)application);
            version.setTimestamp(application.getCreateDate());
            version = (EntityVersion)versionService.save((Object)version);
            this.log.info((Object)"Application");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)e);
        }
        application = (Application)applicationService.find((Object)application.getId());
        this.log.info((Object)("Application id = " + application.getId() + " created."));
    }

    public static void main(String[] args) throws Exception {
    }
}

