/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.queries.textfieldquery;

import com.imcode.oeplatform.flowengine.queries.textfieldquery.FieldLayout;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.FormatValidator;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextField;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldCRUD;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQuery;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQueryCRUD;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldQueryInstance;
import com.imcode.oeplatform.flowengine.queries.textfieldquery.TextFieldValue;
import com.nordicpeak.flowengine.beans.Flow;
import com.nordicpeak.flowengine.enums.QueryState;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.ImmutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.InstanceMetadata;
import com.nordicpeak.flowengine.interfaces.MutableQueryDescriptor;
import com.nordicpeak.flowengine.interfaces.MutableQueryInstanceDescriptor;
import com.nordicpeak.flowengine.interfaces.Query;
import com.nordicpeak.flowengine.interfaces.QueryInstance;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryCRUDCallback;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryInstance;
import com.nordicpeak.flowengine.queries.basequery.BaseQueryProviderModule;
import com.nordicpeak.flowengine.utils.JTidyUtils;
import com.nordicpeak.flowengine.utils.TextTagReplacer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.annotations.XSLVariable;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.utils.FCKUtils;
import se.unlogic.hierarchy.core.validationerrors.InvalidFormatValidationError;
import se.unlogic.openhierarchy.foregroundmodules.siteprofile.interfaces.SiteProfile;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOWrapper;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.random.RandomUtils;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.validation.TooLongContentValidationError;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLGenerator;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;
import se.unlogic.webutils.url.URLRewriter;

public class TextFieldQueryProviderModule
extends BaseQueryProviderModule<TextFieldQueryInstance>
implements BaseQueryCRUDCallback {
    @XSLVariable(prefix="java.")
    protected String fieldLayoutNewLine = "This variable should be set by your stylesheet";
    @XSLVariable(prefix="java.")
    protected String fieldLayoutFloat = "This variable should be set by your stylesheet";
    private static final RelationQuery SAVE_QUERY_INSTANCE_RELATION_QUERY = new RelationQuery(new Field[]{TextFieldQueryInstance.VALUES_RELATION});
    private AnnotatedDAO<TextFieldQuery> queryDAO;
    private AnnotatedDAO<TextFieldQueryInstance> queryInstanceDAO;
    private TextFieldQueryCRUD queryCRUD;
    private TextFieldCRUD textFieldCRUD;
    private QueryParameterFactory<TextFieldQuery, Integer> queryIDParamFactory;
    private QueryParameterFactory<TextFieldQueryInstance, Integer> queryInstanceIDParamFactory;

    protected void createDAOs(DataSource dataSource) throws Exception {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)TextFieldQueryProviderModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(((Object)((Object)this)).getClass().getResourceAsStream("DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        SimpleAnnotatedDAOFactory daoFactory = new SimpleAnnotatedDAOFactory(dataSource);
        this.queryDAO = daoFactory.getDAO(TextFieldQuery.class);
        this.queryInstanceDAO = daoFactory.getDAO(TextFieldQueryInstance.class);
        this.queryCRUD = new TextFieldQueryCRUD((AnnotatedDAOWrapper<TextFieldQuery, Integer>)this.queryDAO.getWrapper(Integer.class), (BeanRequestPopulator<TextFieldQuery>)new AnnotatedRequestPopulator(TextFieldQuery.class), "TextFieldQuery", "query", null, this);
        this.textFieldCRUD = new TextFieldCRUD((AnnotatedDAOWrapper<TextField, Integer>)daoFactory.getDAO(TextField.class).getWrapper(Integer.class), (BeanRequestPopulator<TextField>)new AnnotatedRequestPopulator(TextField.class), "TextField", "textfield", null, this);
        this.queryIDParamFactory = this.queryDAO.getParamFactory("queryID", Integer.class);
        this.queryInstanceIDParamFactory = this.queryInstanceDAO.getParamFactory("queryInstanceID", Integer.class);
    }

    public Query createQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        TextFieldQuery query = new TextFieldQuery();
        query.setLayout(FieldLayout.FLOAT);
        query.setQueryID(descriptor.getQueryID());
        this.queryDAO.add((Object)query, transactionHandler, null);
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query importQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        TextFieldQuery query = new TextFieldQuery();
        query.setQueryID(descriptor.getQueryID());
        query.populate(descriptor.getImportParser().getNode(XMLGenerator.getElementName(query.getClass())));
        this.queryDAO.add((Object)query, transactionHandler, null);
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor) throws SQLException {
        TextFieldQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public Query getQuery(MutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        TextFieldQuery query = this.getQuery(descriptor.getQueryID(), transactionHandler);
        if (query == null) {
            return null;
        }
        query.init(descriptor, this.getFullAlias() + "/config/" + descriptor.getQueryID());
        return query;
    }

    public QueryInstance getQueryInstance(MutableQueryInstanceDescriptor descriptor, String instanceManagerID, HttpServletRequest req, User user, InstanceMetadata instanceMetadata) throws SQLException {
        TextFieldQueryInstance queryInstance;
        if (descriptor.getQueryInstanceID() == null) {
            queryInstance = new TextFieldQueryInstance();
        } else {
            queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
            if (queryInstance == null) {
                return null;
            }
        }
        queryInstance.setQuery(this.getQuery(descriptor.getQueryDescriptor().getQueryID()));
        if (queryInstance.getQuery() == null) {
            return null;
        }
        if (req != null) {
            FCKUtils.setAbsoluteFileUrls((Object)queryInstance.getQuery(), (String)(RequestUtils.getFullContextPathURL((HttpServletRequest)req) + this.ckConnectorModuleAlias));
            URLRewriter.setAbsoluteLinkUrls((Object)queryInstance.getQuery(), (HttpServletRequest)req, (boolean)true);
        }
        TextTagReplacer.replaceTextTags((Object)queryInstance.getQuery(), (SiteProfile)instanceMetadata.getSiteProfile());
        queryInstance.set(descriptor);
        return queryInstance;
    }

    private TextFieldQuery getQuery(Integer queryID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{TextFieldQuery.TEXT_FIELDS_RELATION});
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        return (TextFieldQuery)this.queryDAO.get(query);
    }

    private TextFieldQuery getQuery(Integer queryID, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{TextFieldQuery.TEXT_FIELDS_RELATION});
        query.addParameter(this.queryIDParamFactory.getParameter((Object)queryID));
        return (TextFieldQuery)this.queryDAO.get(query, transactionHandler);
    }

    private TextFieldQueryInstance getQueryInstance(Integer queryInstanceID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery(new Field[]{TextFieldQueryInstance.VALUES_RELATION, TextFieldValue.TEXT_FIELD_RELATION, TextFieldQueryInstance.QUERY_RELATION, TextFieldQuery.TEXT_FIELDS_RELATION});
        query.addParameter(this.queryInstanceIDParamFactory.getParameter((Object)queryInstanceID));
        return (TextFieldQueryInstance)this.queryInstanceDAO.get(query);
    }

    public void save(TextFieldQueryInstance queryInstance, TransactionHandler transactionHandler) throws Throwable {
        if (queryInstance.getQueryInstanceID() == null || !queryInstance.getQueryInstanceID().equals(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID())) {
            queryInstance.setQueryInstanceID(queryInstance.getQueryInstanceDescriptor().getQueryInstanceID());
            this.queryInstanceDAO.add((Object)queryInstance, transactionHandler, SAVE_QUERY_INSTANCE_RELATION_QUERY);
        } else {
            this.queryInstanceDAO.update((Object)queryInstance, transactionHandler, SAVE_QUERY_INSTANCE_RELATION_QUERY);
        }
    }

    public void populate(TextFieldQueryInstance queryInstance, HttpServletRequest req, User user, boolean allowPartialPopulation, MutableAttributeHandler attributeHandler) throws ValidationException {
        List<TextField> textFields = queryInstance.getQuery().getFields();
        if (CollectionUtils.isEmpty(textFields)) {
            queryInstance.reset(attributeHandler);
            return;
        }
        ArrayList<Object> validationErrors = new ArrayList<Object>(queryInstance.getQuery().getFields().size());
        ArrayList<TextFieldValue> textFieldValues = new ArrayList<TextFieldValue>(queryInstance.getQuery().getFields().size());
        for (TextField textField : textFields) {
            StringFormatValidator formatValidator;
            String value = req.getParameter("q" + queryInstance.getQuery().getQueryID() + "_field" + textField.getTextFieldID());
            if (StringUtils.isEmpty((String)value)) {
                if (allowPartialPopulation || !textField.isRequired() || queryInstance.getQueryInstanceDescriptor().getQueryState() != QueryState.VISIBLE_REQUIRED) continue;
                validationErrors.add(new ValidationError(textField.getTextFieldID().toString(), ValidationErrorType.RequiredField));
                continue;
            }
            value = value.trim();
            Integer maxLength = textField.getMaxContentLength();
            if (maxLength == null) {
                maxLength = 255;
            }
            if (value.length() > 255) {
                validationErrors.add(new TooLongContentValidationError(textField.getTextFieldID().toString(), (long)value.length(), 255L));
                continue;
            }
            if (textField.getFormatValidator() != null && !(formatValidator = this.getStringFormatValidator(textField)).validateFormat(value)) {
                validationErrors.add(new InvalidFormatValidationError(textField.getTextFieldID().toString(), textField.getInvalidFormatMessage()));
                continue;
            }
            textFieldValues.add(new TextFieldValue(textField, value));
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        for (TextField textField : textFields) {
            if (!textField.isSetAsAttribute()) continue;
            attributeHandler.removeAttribute(textField.getAttributeName());
        }
        if (textFieldValues.isEmpty()) {
            queryInstance.setValues(null);
            queryInstance.getQueryInstanceDescriptor().setPopulated(false);
        } else {
            queryInstance.setValues(textFieldValues);
            queryInstance.getQueryInstanceDescriptor().setPopulated(true);
            for (TextFieldValue textFieldValue : textFieldValues) {
                if (!textFieldValue.getTextField().isSetAsAttribute()) continue;
                attributeHandler.setAttribute(textFieldValue.getTextField().getAttributeName(), (Object)textFieldValue.getValue());
            }
        }
    }

    private StringFormatValidator getStringFormatValidator(TextField textField) {
        try {
            return (StringFormatValidator)ReflectionUtils.getInstance((String)textField.getFormatValidator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @WebPublic(alias="config")
    public ForegroundModuleResponse configureQuery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.queryCRUD.show(req, res, user, uriParser);
    }

    @WebPublic(alias="updatequery")
    public ForegroundModuleResponse updateQuery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.queryCRUD.update(req, res, user, uriParser);
    }

    @WebPublic(alias="addtextfield")
    public ForegroundModuleResponse addTextField(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        TextFieldQuery query = (TextFieldQuery)this.queryCRUD.getRequestedBean(req, res, user, uriParser, null);
        if (query != null) {
            this.checkUpdateQueryAccess(user, query);
            req.setAttribute("TextFieldQuery", (Object)query);
            return this.textFieldCRUD.add(req, res, user, uriParser);
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="updatetextfield")
    public ForegroundModuleResponse updateTextField(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.textFieldCRUD.update(req, res, user, uriParser);
    }

    @WebPublic(alias="deletetextfield")
    public ForegroundModuleResponse deleteTextField(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.textFieldCRUD.delete(req, res, user, uriParser);
    }

    @WebPublic(alias="sorttextfields")
    public ForegroundModuleResponse sortTextFields(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.queryCRUD.sort(req, res, user, uriParser);
    }

    public boolean deleteQuery(ImmutableQueryDescriptor descriptor, TransactionHandler transactionHandler) throws SQLException {
        TextFieldQuery query = this.getQuery(descriptor.getQueryID());
        if (query == null) {
            return false;
        }
        this.queryDAO.delete((Object)query, transactionHandler);
        return true;
    }

    public boolean deleteQueryInstance(ImmutableQueryInstanceDescriptor descriptor, TransactionHandler transactionHandler) throws Throwable {
        TextFieldQueryInstance queryInstance = this.getQueryInstance(descriptor.getQueryInstanceID());
        if (queryInstance == null) {
            return false;
        }
        this.queryInstanceDAO.delete((Object)queryInstance, transactionHandler);
        return true;
    }

    @WebPublic
    public ForegroundModuleResponse addDummyAlternatives(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        HighLevelQuery query = new HighLevelQuery(new Field[]{TextFieldQuery.TEXT_FIELDS_RELATION});
        List queries = this.queryDAO.getAll(query);
        if (queries == null) {
            return null;
        }
        for (TextFieldQuery textFieldQuery : queries) {
            if (textFieldQuery.getFields() != null) continue;
            this.log.info((Object)("Adding dummy fields to query " + textFieldQuery));
            int fieldCount = RandomUtils.getRandomInt((int)1, (int)5);
            textFieldQuery.setLayout(FieldLayout.values()[RandomUtils.getRandomInt((int)0, (int)2)]);
            textFieldQuery.setFields(new ArrayList<TextField>(fieldCount));
            while (textFieldQuery.getFields().size() < fieldCount) {
                TextField textField = new TextField();
                textField.setLabel("Field " + (textFieldQuery.getFields().size() + 1));
                textField.setRequired(RandomUtils.getRandomInt((int)0, (int)2) == 1);
                textField.setSortIndex(textFieldQuery.getFields().size());
                textFieldQuery.getFields().add(textField);
            }
            this.queryDAO.update((Object)textFieldQuery, (RelationQuery)query);
        }
        return null;
    }

    public String getTitlePrefix() {
        return ((ForegroundModuleDescriptor)this.moduleDescriptor).getName();
    }

    public String getFieldLayoutName(FieldLayout layout) {
        if (layout.equals((Object)FieldLayout.FLOAT)) {
            return this.fieldLayoutFloat;
        }
        if (layout.equals((Object)FieldLayout.NEW_LINE)) {
            return this.fieldLayoutNewLine;
        }
        return layout.toString();
    }

    public void checkUpdateQueryAccess(User user, TextFieldQuery query) throws AccessDeniedException, SQLException {
        this.flowAdminModule.checkFlowStructureManipulationAccess(user, (Flow)query.getQueryDescriptor().getStep().getFlow());
    }

    public void redirectToQueryConfig(TextFieldQuery query, HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.sendRedirect(req.getContextPath() + this.getFullAlias() + "/config/" + query.getQueryID());
    }

    public List<FormatValidator> getFormatValidators() {
        ArrayList<FormatValidator> validators = new ArrayList<FormatValidator>();
        FormatValidator validator = new FormatValidator("E-post", "se.unlogic.emailutils.validation.StringEmailValidator", "Du m\ufffdste fylla i en giltig e-post adress");
        validators.add(validator);
        validator = new FormatValidator("Positivt heltal", "se.unlogic.standardutils.validation.PositiveStringIntegerValidator", "Du m\ufffdste fylla i ett positivt heltal");
        validators.add(validator);
        validator = new FormatValidator("Personnummer", "se.unlogic.standardutils.populators.SocialSecurityPopulator", "Du m\ufffdste fylla i ett giltigt personnummer");
        validators.add(validator);
        return validators;
    }

    public void copyQuery(MutableQueryDescriptor sourceQueryDescriptor, MutableQueryDescriptor copyQueryDescriptor, TransactionHandler transactionHandler) throws SQLException {
        TextFieldQuery query = this.getQuery(sourceQueryDescriptor.getQueryID(), transactionHandler);
        query.setQueryID(copyQueryDescriptor.getQueryID());
        if (query.getFields() != null) {
            for (TextField textField : query.getFields()) {
                textField.setTextFieldID(null);
            }
        }
        this.queryDAO.add((Object)query, transactionHandler, new RelationQuery(new Field[]{TextFieldQuery.TEXT_FIELDS_RELATION}));
    }

    protected void appendPDFData(Document doc, Element showQueryValuesElement, TextFieldQueryInstance queryInstance) {
        super.appendPDFData(doc, showQueryValuesElement, (BaseQueryInstance)queryInstance);
        if (queryInstance.getQuery().getDescription() != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"Description", (String)JTidyUtils.getXHTML((String)queryInstance.getQuery().getDescription()));
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)showQueryValuesElement, (String)"isHTMLDescription", (Object)(queryInstance.getQuery().getDescription().contains("<") && queryInstance.getQuery().getDescription().contains(">") ? 1 : 0));
        }
    }
}

