/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.oeplatform.flowengine.populators.dao;

import com.imcode.oeplatform.flowengine.populators.dao.DaoPopulator;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.populators.BaseStringPopulator;

public final class DaoPopulatorFactory {
    private DaoPopulatorFactory() {
    }

    public static <T extends Serializable> DaoPopulator<T> get(Class<? extends T> clazz, Function<String, T> fromStringmapper, Function<Object, String> toStringmapper) {
        return new LambdaDelegationBeanStringPopulator<T>(clazz, fromStringmapper, toStringmapper);
    }

    public static <T extends Serializable> DaoPopulator<T> get(Class<? extends T> clazz) {
        return DaoPopulatorFactory.get(clazz, DaoPopulator::fromBase64String, DaoPopulator::toBase64String);
    }

    private static class LambdaDelegationBeanStringPopulator<T extends Serializable>
    extends BaseStringPopulator<T>
    implements DaoPopulator<T> {
        private final Function<String, T> fromStringmapper;
        private final Function<Object, String> toStringmapper;
        private final Class<? extends T> clazz;

        public LambdaDelegationBeanStringPopulator(Class<? extends T> clazz, Function<String, T> fromStringmapper, Function<Object, String> toStringmapper) {
            Objects.requireNonNull(clazz);
            Objects.requireNonNull(fromStringmapper);
            Objects.requireNonNull(toStringmapper);
            this.fromStringmapper = fromStringmapper;
            this.toStringmapper = toStringmapper;
            this.clazz = clazz;
        }

        protected boolean validateDefaultFormat(String value) {
            return true;
        }

        public T getValue(String value) {
            return (T)((Serializable)this.fromStringmapper.apply(value));
        }

        public void populate(PreparedStatementQuery query, int paramIndex, Object bean) throws SQLException {
            query.setString(paramIndex, this.toStringmapper.apply(bean));
        }

        public Class<? extends T> getType() {
            return this.clazz;
        }
    }
}

